/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.List;

@BugPattern(name="ThrowError", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer throwing a RuntimeException rather than Error. Errors are often handled poorly by libraries resulting in unexpected behavior and resource leaks. It's not obvious that 'catch (Exception e)' does not catch Error.\nErrors are normally thrown by the JVM when the system, not just the application, is in a bad state. For example, LinkageError is thrown by the JVM when it encounters incompatible classes, and NoClassDefFoundError when a class cannot be found. These should be less common and handled differently from application failures.\nThis check  is intended to be advisory - it's fine to @SuppressWarnings(\"ThrowError\") in certain cases, but is usually not recommended unless you are writing a testing library that throws AssertionError.")
@AutoService(value={BugChecker.class})
public final class ThrowError
extends BugChecker
implements BugChecker.ThrowTreeMatcher {
    private static final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();
    private static final Matcher<ExpressionTree> ERROR = MoreMatchers.isSubtypeOf(Error.class);

    public Description matchThrow(ThrowTree tree, VisitorState state) {
        ExpressionTree expression = tree.getExpression();
        if (!(expression instanceof NewClassTree)) {
            return Description.NO_MATCH;
        }
        NewClassTree newClassTree = (NewClassTree)expression;
        if (!ERROR.matches((Tree)newClassTree.getIdentifier(), state) || TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)ThrowError.generateFix(newClassTree, state)).build();
    }

    private static SuggestedFix generateFix(NewClassTree newClassTree, VisitorState state) {
        Type throwableType = ASTHelpers.getType((Tree)newClassTree.getIdentifier());
        if (!ASTHelpers.isSameType((Type)throwableType, (Type)state.getTypeFromString(AssertionError.class.getName()), (VisitorState)state)) {
            return SuggestedFix.emptyFix();
        }
        List<? extends ExpressionTree> arguments = newClassTree.getArguments();
        if (arguments.isEmpty()) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String qualifiedName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)IllegalStateException.class.getName());
            return fix.replace((Tree)newClassTree.getIdentifier(), qualifiedName).build();
        }
        ExpressionTree firstArgument = arguments.get(0);
        if (ASTHelpers.isSameType((Type)ASTHelpers.getResultType((ExpressionTree)firstArgument), (Type)state.getTypeFromString(String.class.getName()), (VisitorState)state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String qualifiedName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)(compileTimeConstExpressionMatcher.matches((Tree)firstArgument, state) ? "com.palantir.logsafe.exceptions.SafeIllegalStateException" : IllegalStateException.class.getName()));
            return fix.replace((Tree)newClassTree.getIdentifier(), qualifiedName).build();
        }
        return SuggestedFix.emptyFix();
    }
}

