/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(name="UnnecessaryLambdaArgumentParentheses", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Lambdas with a single parameter do not require argument parentheses.")
@AutoService(value={BugChecker.class})
public final class UnnecessaryLambdaArgumentParentheses
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher {
    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        if (!UnnecessaryLambdaArgumentParentheses.quickCheck(tree, state)) {
            return Description.NO_MATCH;
        }
        List tokens = state.getTokensForNode((Tree)tree);
        int depth = 0;
        int identifiers = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            ErrorProneToken token = (ErrorProneToken)tokens.get(i);
            if (token.kind() == Tokens.TokenKind.IDENTIFIER) {
                if (++identifiers <= 1) continue;
                return Description.NO_MATCH;
            }
            if (token.kind() == Tokens.TokenKind.LPAREN) {
                ++depth;
                continue;
            }
            if (token.kind() == Tokens.TokenKind.RPAREN && --depth == 0) {
                List offsetTokens = state.getOffsetTokensForNode((Tree)tree);
                ErrorProneToken firstToken = (ErrorProneToken)offsetTokens.get(0);
                ErrorProneToken offsetToken = (ErrorProneToken)offsetTokens.get(i);
                return this.buildDescription(tree.getParameters().get(0)).addFix((Fix)SuggestedFix.builder().replace(firstToken.pos(), firstToken.endPos(), "").replace(offsetToken.pos(), offsetToken.endPos(), "").build()).build();
            }
            return Description.NO_MATCH;
        }
        return Description.NO_MATCH;
    }

    private static boolean quickCheck(LambdaExpressionTree tree, VisitorState state) {
        if (tree.getParameters().size() != 1) {
            return false;
        }
        int start = ((JCTree)((Object)tree)).getStartPosition();
        if (start == -1) {
            return false;
        }
        CharSequence source = state.getSourceCode();
        if (source == null) {
            return false;
        }
        return source.charAt(start) == '(';
    }
}

