/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.List;

@BugPattern(name="ValidateConstantMessage", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Allow only constant messages to Validate.X() methods")
@AutoService(value={BugChecker.class})
public final class ValidateConstantMessage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> VALIDATE_METHODS = MethodMatchers.staticMethod().onClassAny(new String[]{"org.apache.commons.lang3.Validate", "org.apache.commons.lang.Validate"});
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();
    private static final ImmutableMap<String, Integer> VALIDATE_METHODS_MESSAGE_ARGS = ImmutableMap.builder().put((Object)"exclusiveBetween", (Object)4).put((Object)"finite", (Object)2).put((Object)"inclusiveBetween", (Object)4).put((Object)"isAssignableFrom", (Object)3).put((Object)"isInstanceOf", (Object)3).put((Object)"isTrue", (Object)2).put((Object)"matchesPattern", (Object)3).put((Object)"noNullElements", (Object)2).put((Object)"notBlank", (Object)2).put((Object)"notEmpty", (Object)2).put((Object)"notNaN", (Object)2).put((Object)"notNull", (Object)2).put((Object)"validIndex", (Object)3).put((Object)"validState", (Object)2).put((Object)"allElementsOfType", (Object)3).build();
    private static final Supplier<Type> JAVA_STRING = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.String"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!VALIDATE_METHODS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String methodName = ASTHelpers.getSymbol((MethodInvocationTree)tree).name.toString();
        if (!VALIDATE_METHODS_MESSAGE_ARGS.containsKey((Object)methodName)) {
            return Description.NO_MATCH;
        }
        int messageArgNumber = (Integer)VALIDATE_METHODS_MESSAGE_ARGS.get((Object)methodName);
        List<? extends ExpressionTree> args = tree.getArguments();
        if (args.size() < messageArgNumber) {
            return Description.NO_MATCH;
        }
        ExpressionTree messageArg = args.get(messageArgNumber - 1);
        boolean isStringType = ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)messageArg), (Type)((Type)JAVA_STRING.get(state)), (VisitorState)state);
        boolean isConstantString = this.compileTimeConstExpressionMatcher.matches((Tree)messageArg, state);
        if (!isStringType || isConstantString) {
            return Description.NO_MATCH;
        }
        if (TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Validate.X() statement uses a non-constant message").build();
    }
}

