/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="VisibleForTestingPackagePrivate", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="@VisibleForTesting members should be package-private.")
@AutoService(value={BugChecker.class})
public final class VisibleForTestingPackagePrivate
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<Tree> matcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAnnotation(VisibleForTesting.class), Matchers.anyOf((Matcher[])new Matcher[]{MoreMatchers.hasExplicitModifier(Modifier.PROTECTED), MoreMatchers.hasExplicitModifier(Modifier.PUBLIC)})});

    private Description match(Tree tree, VisitorState state) {
        if (matcher.matches(tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PROTECTED, Modifier.PUBLIC}).orElseGet(SuggestedFix::emptyFix)).build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.match(tree, state);
    }
}

