/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="You should not use Conjure endpoints that are marked for removal as that may block upgrades in the near future. You can explicitly disable this check on a case-by-case basis using @SuppressWarnings(\"ConjureEndpointDeprecatedForRemoval\").")
@AutoService(value={BugChecker.class})
public final class ConjureEndpointDeprecatedForRemoval
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final String CONJURE_CLIENT_ENDPOINT = "com.palantir.conjure.java.lib.internal.ClientEndpoint";
    private static final Matcher<Tree> FULL_DEPRECATED_CONJURE_ENDPOINT_MATCHER = Matchers.symbolMatcher((symbol, state) -> symbol.isDeprecatedForRemoval() && ASTHelpers.hasAnnotation((Symbol)symbol, (String)CONJURE_CLIENT_ENDPOINT, (VisitorState)state));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.checkTree(tree, state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.checkTree(tree, state);
    }

    private Description checkTree(Tree tree, VisitorState state) {
        if (!FULL_DEPRECATED_CONJURE_ENDPOINT_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

