/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.net.InetSocketAddress;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Calling 'new InetSocketAddress(host, port)' results in a DNS lookup which prevents the address from following DNS changes in the future because it's already resolved. Additionally this is a potential a network request, making the invocation significantly more expensive than expected depending on the environment.\nThis check is intended to be advisory - it's fine to @SuppressWarnings(\"DnsLookup\") in certain cases, but is usually not recommended.")
@AutoService(value={BugChecker.class})
public final class DnsLookup
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> INET_SOCKET_ADDRESS_MATCHER = MethodMatchers.constructor().forClass(InetSocketAddress.class.getName()).withParameters(String.class.getName(), new String[]{Integer.TYPE.getName()});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (tree.getClassBody() == null && INET_SOCKET_ADDRESS_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().replace(DnsLookup.startPosition(tree), state.getEndPosition((Tree)tree.getIdentifier()), state.getSourceForNode((Tree)tree.getIdentifier()) + ".createUnresolved").build()).build();
        }
        return Description.NO_MATCH;
    }

    private static int startPosition(ExpressionTree tree) {
        return ((JCTree)((Object)tree)).getStartPosition();
    }
}

