/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.lang.reflect.InvocationTargetException;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, summary="InvocationTargetException.getTargetException() predates the general-purpose exception chaining facility. The Throwable.getCause() method is now the preferred means of obtaining this information. Source: https://docs.oracle.com/en/java/javase/17/docs/api//java.base/java/lang/reflect/InvocationTargetException.html#getTargetException()")
@AutoService(value={BugChecker.class})
public final class InvocationTargetExceptionGetTargetException
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ITE_GET_TARGET_EXCEPTION_MATCHER = Matchers.instanceMethod().onDescendantOf(InvocationTargetException.class.getName()).named("getTargetException").withNoParameters();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return ITE_GET_TARGET_EXCEPTION_MATCHER.matches((Tree)tree, state) ? this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"getCause", (VisitorState)state)) : Description.NO_MATCH;
    }
}

