/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Assert statements should not be used. Asserts are generally enabled in tests but disabled in production, which means code can execute in production that is impossible to test.\nIf you're confident that an 'assert' is required, this check may be suppressed using @SuppressWarnings(\"BadAssert\")")
@AutoService(value={BugChecker.class})
public final class BadAssert
extends BugChecker
implements BugChecker.AssertTreeMatcher {
    private static final String LOGSAFE_PRECONDITIONS = "com.palantir.logsafe.Preconditions";
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();

    public Description matchAssert(AssertTree tree, VisitorState state) {
        ExpressionTree condition = tree.getCondition();
        ExpressionTree detail = tree.getDetail();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (detail == null) {
            fix.replace((Tree)tree, String.format("if (!%s) { throw new IllegalStateException(); }", state.getSourceForNode((Tree)condition)));
        } else if (BadAssert.isString(ASTHelpers.getType((Tree)detail), state) && this.compileTimeConstExpressionMatcher.matches((Tree)detail, state)) {
            fix.replace((Tree)tree, String.format("%s.checkState(%s, %s)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)LOGSAFE_PRECONDITIONS), state.getSourceForNode((Tree)condition), state.getSourceForNode((Tree)detail)));
        } else {
            Object message = BadAssert.isString(ASTHelpers.getType((Tree)detail), state) ? state.getSourceForNode((Tree)detail) : "String.valueOf(" + state.getSourceForNode((Tree)detail) + ")";
            fix.replace((Tree)tree, String.format("if (!%s) { throw new IllegalStateException(%s); }", state.getSourceForNode((Tree)condition), message));
        }
        return this.buildDescription(tree).addFix((Fix)fix.build()).build();
    }

    private static boolean isString(Type type, VisitorState state) {
        return state.getTypes().isSameType(type, state.getTypeFromString(String.class.getName()));
    }
}

