/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Record type has an array field and hasn't overridden equals/hashcode. By default array equality performs reference equality only. Consider using an immutable Collection for the field, using Immutables instead of the record, or overriding equals/hashCode in the record.", severity=BugPattern.SeverityLevel.WARNING)
@AutoService(value={BugChecker.class})
public final class DangerousRecordArrayField
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<VariableTree> IS_ARRAY_VARIABLE = Matchers.isArrayType();
    private static final Matcher<MethodTree> EQUALS_MATCHER = Matchers.equalsMethodDeclaration();
    private static final Matcher<MethodTree> HASHCODE_MATCHER = Matchers.hashCodeMethodDeclaration();

    public Description matchClass(ClassTree classTree, VisitorState state) {
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (!ASTHelpers.isRecord((Symbol)classSymbol)) {
            return Description.NO_MATCH;
        }
        if (!DangerousRecordArrayField.hasArrayField(classTree, state)) {
            return Description.NO_MATCH;
        }
        if (DangerousRecordArrayField.hasNonTrivialEqualsAndHashCode(classTree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(classTree).build();
    }

    private static boolean hasArrayField(ClassTree classTree, VisitorState state) {
        for (Tree tree : classTree.getMembers()) {
            VariableTree variableTree;
            if (!(tree instanceof VariableTree) || !IS_ARRAY_VARIABLE.matches((Tree)(variableTree = (VariableTree)tree), state)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonTrivialEqualsAndHashCode(ClassTree classTree, VisitorState state) {
        boolean hasEquals = false;
        boolean hasHashCode = false;
        for (Tree tree : classTree.getMembers()) {
            if (!(tree instanceof MethodTree)) continue;
            MethodTree methodTree = (MethodTree)tree;
            hasEquals = hasEquals || EQUALS_MATCHER.matches((Tree)methodTree, state);
            hasHashCode = hasHashCode || HASHCODE_MATCHER.matches((Tree)methodTree, state);
        }
        return hasEquals && hasHashCode;
    }
}

