/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Should not use String.intern(). Java string intern is complex and unpredictable. In most cases intern performs worse than pure-java implementations such as Guava Interners (https://guava.dev/releases/27.0.1-jre/api/docs/com/google/common/collect/Interners.html). If you are confident that String.intern is the correct tool, please make sure you fully understand the consequences.\nFrom https://shipilev.net/jvm/anatomy-quarks/10-string-intern/\n> For OpenJDK, String.intern() is the gateway to native JVM String table, and it comes with\n> caveats: throughput, memory footprint, pause time problems will await the users. It is very\n> easy to underestimate the impact of these caveats. Hand-rolled deduplicators/interners are\n> working much more reliably, because they are working on Java side, are just the regular Java\n> objects, generally better sized/resized, and also can be thrown away completely when not needed\n> anymore. GC-assisted String deduplication does alleviate things even more.\n> In almost every project we were taking care of, removing String.intern() from the hotpaths, \n> or optionally replacing it with a handrolled deduplicator, was the very profitable performance\n> optimization. Do not use String.intern() without thinking very hard about it, okay?")
@AutoService(value={BugChecker.class})
public final class DangerousStringInternUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> STRING_INTERN_METHOD_MATCHER = MethodMatchers.instanceMethod().onExactClass(String.class.getName()).named("intern").withNoParameters();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (STRING_INTERN_METHOD_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

