/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Collection;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"Performance"}, summary="jOOQ batch methods that execute without bind args can cause performance problems.", explanation="When batch queries execute without bind args, each query is sent to the database as a string with all variables inline. Inline variables cause each query in the batch to be unique, so the database uses extra CPU and memory to parse and query plan each query. Instead use one of the other jOOQ batch methods that is documented as executing queries with bind args, as this allows parsing and query planning the query once and then executing any number of times with different bind values.")
@AutoService(value={BugChecker.class})
public final class JooqBatchWithoutBindArgs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String DSL_CONTEXT = "org.jooq.DSLContext";
    private static final String BATCH = "batch";
    private static final Supplier<Type> QUERY_TYPE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("org.jooq.Query"));
    private static final Matcher<ExpressionTree> BATCH_WITHOUT_BINDS_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("org.jooq.DSLContext").named("batch").withParameters("org.jooq.Queries", new String[0]), MethodMatchers.instanceMethod().onDescendantOf("org.jooq.DSLContext").named("batch").withParameters(Collection.class.getName(), new String[0]), MethodMatchers.instanceMethod().onDescendantOf("org.jooq.DSLContext").named("batch").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf((Supplier)Suppliers.STRING_TYPE))), MethodMatchers.instanceMethod().onDescendantOf("org.jooq.DSLContext").named("batch").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf(QUERY_TYPE)))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (BATCH_WITHOUT_BINDS_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

