/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractAsKeyOfSetOrMap;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.io.Serializable;
import java.util.function.IntPredicate;

abstract class MoreAbstractAsKeyOfSetOrMap
extends AbstractAsKeyOfSetOrMap {
    private static final Matcher<ExpressionTree> GUAVA_CACHE_BUILDER = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.cache.CacheBuilder").named("build");
    private static final Matcher<ExpressionTree> CAFFEINE_CACHE_BUILDER = MethodMatchers.instanceMethod().onDescendantOf("com.github.benmanes.caffeine.cache.Caffeine").namedAnyOf(new String[]{"build", "buildAsync"});
    private static final Matcher<ExpressionTree> SET_COLLECTOR = MethodMatchers.staticMethod().onClass("java.util.stream.Collectors").named("toSet").withNoParameters();
    private static final Matcher<ExpressionTree> UNMODIFIABLE_SET_COLLECTOR = MethodMatchers.staticMethod().onClass("java.util.stream.Collectors").named("toUnmodifiableSet").withNoParameters();
    private static final Matcher<ExpressionTree> IMMUTABLE_SET_COLLECTOR = MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSet").named("toImmutableSet").withNoParameters();
    private static final Matcher<MethodInvocationTree> MAP_COLLECTOR = Matchers.allOf((Matcher[])new Matcher[]{MoreAbstractAsKeyOfSetOrMap.argumentCount(count -> count < 4), MethodMatchers.staticMethod().onClass("java.util.stream.Collectors").named("toMap")});
    private static final Matcher<MethodInvocationTree> CONCURRENT_MAP_COLLECTOR = Matchers.allOf((Matcher[])new Matcher[]{MoreAbstractAsKeyOfSetOrMap.argumentCount(count -> count < 4), MethodMatchers.staticMethod().onClass("java.util.stream.Collectors").named("toConcurrentMap")});
    private static final Matcher<ExpressionTree> UNMODIFIABLE_MAP_COLLECTOR = MethodMatchers.staticMethod().onClass("java.util.stream.Collectors").named("toUnmodifiableMap");
    private static final Matcher<ExpressionTree> IMMUTABLE_MAP_COLLECTOR = MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableMap").named("toImmutableMap");
    private static final Matcher<ExpressionTree> JAVA_UTIL_MAP_OF = MethodMatchers.staticMethod().onClass("java.util.Map").named("of");
    private static final Matcher<ExpressionTree> JAVA_UTIL_SET_OF = MethodMatchers.staticMethod().onClass("java.util.Set").named("of");
    private static final Matcher<ExpressionTree> IMMUTABLE_MAP_OF = MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableMap").namedAnyOf(new String[]{"of", "copyOf"});
    private static final Matcher<ExpressionTree> IMMUTABLE_MAP_BUILDER = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.collect.ImmutableMap.Builder").named("build");
    private static final Matcher<ExpressionTree> IMMUTABLE_SET_OF = MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSet").namedAnyOf(new String[]{"of", "copyOf"});
    private static final Matcher<ExpressionTree> IMMUTABLE_SET_BUILDER = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.collect.ImmutableSet.Builder").named("build");
    private static final Matcher<ExpressionTree> STREAMEX_TO_MAP = MethodMatchers.instanceMethod().onDescendantOf("one.util.streamex.EntryStream").namedAnyOf(new String[]{"toMap", "toImmutableMap"});
    private static final Matcher<ExpressionTree> STREAMEX_TO_SET = MethodMatchers.instanceMethod().onDescendantOf("one.util.streamex.AbstractStreamEx").namedAnyOf(new String[]{"toSet", "toImmutableSet"});
    private static final Matcher<MethodInvocationTree> HASH_KEYED_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{GUAVA_CACHE_BUILDER, CAFFEINE_CACHE_BUILDER, JAVA_UTIL_MAP_OF, JAVA_UTIL_SET_OF, IMMUTABLE_MAP_OF, IMMUTABLE_MAP_BUILDER, IMMUTABLE_SET_OF, IMMUTABLE_SET_BUILDER, STREAMEX_TO_MAP, STREAMEX_TO_SET});
    private static final Matcher<MethodInvocationTree> HASH_KEYED_COLLECTOR_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{SET_COLLECTOR, UNMODIFIABLE_SET_COLLECTOR, IMMUTABLE_SET_COLLECTOR, MAP_COLLECTOR, CONCURRENT_MAP_COLLECTOR, UNMODIFIABLE_MAP_COLLECTOR, IMMUTABLE_MAP_COLLECTOR});
    private static final Supplier<Symbol> JAVA_UTIL_STREAM_COLLECTOR = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString("java.util.stream.Collector"));

    MoreAbstractAsKeyOfSetOrMap() {
    }

    public final Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Description superResult = super.matchMethodInvocation(tree, state);
        if (!Description.NO_MATCH.equals(superResult)) {
            return superResult;
        }
        if (HASH_KEYED_METHODS.matches((Tree)tree, state)) {
            return this.checkType(tree, ASTHelpers.getResultType((ExpressionTree)tree), state);
        }
        if (HASH_KEYED_COLLECTOR_METHODS.matches((Tree)tree, state)) {
            Type collectorType = ASTHelpers.getResultType((ExpressionTree)tree);
            if (collectorType == null) {
                return Description.NO_MATCH;
            }
            Symbol collectorSymbol = (Symbol)JAVA_UTIL_STREAM_COLLECTOR.get(state);
            if (collectorSymbol == null) {
                return Description.NO_MATCH;
            }
            Type asParameterizedCollector = state.getTypes().asSuper(collectorType, collectorSymbol);
            if (asParameterizedCollector == null) {
                return Description.NO_MATCH;
            }
            Type collectorResultType = asParameterizedCollector.getTypeArguments().get(2);
            return this.checkType(tree, collectorResultType, state);
        }
        return Description.NO_MATCH;
    }

    private Description checkType(Tree tree, Type type, VisitorState state) {
        List<Type> typeArguments = type.getTypeArguments();
        if (!typeArguments.isEmpty() && this.isBadType((Type)typeArguments.get(0), state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static Matcher<MethodInvocationTree> argumentCount(IntPredicate intPredicate) {
        return (Matcher & Serializable)(methodInvocationTree, state) -> intPredicate.test(methodInvocationTree.getArguments().size());
    }
}

