/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="If lambda passed to Optional#orElseGet returns a simple expression, use Optional#orElse instead")
@AutoService(value={BugChecker.class})
public final class OptionalOrElseGetValue
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> OR_ELSE_GET_METHOD = MethodMatchers.instanceMethod().onExactClass("java.util.Optional").named("orElseGet");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!OR_ELSE_GET_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree orElseGetArg = tree.getArguments().get(0);
        if (orElseGetArg.getKind() != Tree.Kind.LAMBDA_EXPRESSION) {
            return Description.NO_MATCH;
        }
        LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)orElseGetArg;
        LambdaExpressionTree.BodyKind bodyKind = lambdaExpressionTree.getBodyKind();
        if (bodyKind != LambdaExpressionTree.BodyKind.EXPRESSION) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionBody = (ExpressionTree)lambdaExpressionTree.getBody();
        if (!OptionalOrElseGetValue.isTrivialExpression(expressionBody) && !OptionalOrElseGetValue.isTrivialSelect(expressionBody)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Prefer Optional#orElse instead of Optional#orElseGet for compile time constants").addFix((Fix)SuggestedFix.builder().merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"orElse", (VisitorState)state)).replace((Tree)orElseGetArg, state.getSourceForNode((Tree)expressionBody)).build()).build();
    }

    private static boolean isTrivialExpression(ExpressionTree tree) {
        return tree instanceof LiteralTree || tree instanceof IdentifierTree;
    }

    private static boolean isTrivialSelect(ExpressionTree tree) {
        return tree instanceof MemberSelectTree && OptionalOrElseGetValue.isTrivialExpression(((MemberSelectTree)tree).getExpression());
    }
}

