/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer JDK `InputStream.transferTo(OutputStream)` over utility methods such as `com.google.common.io.ByteStreams.copy(InputStream, OutputStream)`, `org.apache.commons.io.IOUtils.copy(InputStream, OutputStream)`, `org.apache.commons.io.IOUtils.copyLong(InputStream, OutputStream)` see: https://github.com/palantir/gradle-baseline/issues/2615 ", explanation="Allow for optimization when underlying input stream (such as `ByteArrayInputStream`, `ChannelInputStream`) overrides `long transferTo(OutputStream)` to avoid extra array allocations and copy larger chunks at a time (e.g. allowing 16KiB chunks via `ApacheHttpClientBlockingChannel.ModulatingOutputStream` from #1790).\n\nWhen running on JDK 21+, this also enables 16KiB byte chunk copies via `InputStream.transferTo(OutputStream)` per [JDK-8299336](https://bugs.openjdk.org/browse/JDK-8299336), where as on JDK < 21 and when using Guava `ByteStreams.copy` 8KiB byte chunk copies are used. \n\nReferences:\n\n  * https://github.com/palantir/hadoop-crypto/pull/586\n  * https://bugs.openjdk.org/browse/JDK-8299336\n  * https://bugs.openjdk.org/browse/JDK-8067661\n  * https://bugs.openjdk.org/browse/JDK-8265891\n  * https://bugs.openjdk.org/browse/JDK-8273038\n  * https://bugs.openjdk.org/browse/JDK-8279283\n  * https://bugs.openjdk.org/browse/JDK-8296431\n")
@AutoService(value={BugChecker.class})
public final class PreferInputStreamTransferTo
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MESSAGE = "Prefer InputStream.transferTo(OutputStream)";
    public static final String INPUT_STREAM = "java.io.InputStream";
    private static final Matcher<Tree> INPUT_STREAM_MATCHER = MoreMatchers.isSubtypeOf("java.io.InputStream");
    public static final String OUTPUT_STREAM = "java.io.OutputStream";
    private static final Matcher<Tree> OUTPUT_STREAM_MATCHER = MoreMatchers.isSubtypeOf("java.io.OutputStream");
    private static final Matcher<ExpressionTree> GUAVA_BYTE_STREAM_COPY_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.io.ByteStreams").namedAnyOf(new String[]{"copy"}).withParameters("java.io.InputStream", new String[]{"java.io.OutputStream"});
    private static final Matcher<ExpressionTree> APACHE_COMMONS_BYTE_STREAM_COPY_MATCHER = MethodMatchers.staticMethod().onClass("org.apache.commons.io.IOUtils").namedAnyOf(new String[]{"copy", "copyLarge"}).withParameters("java.io.InputStream", new String[]{"java.io.OutputStream"});
    private static final Matcher<ExpressionTree> AWS_BYTE_STREAM_COPY_MATCHER = MethodMatchers.staticMethod().onClass("com.amazonaws.util.IOUtils").namedAnyOf(new String[]{"copy"}).withParameters("java.io.InputStream", new String[]{"java.io.OutputStream"});
    private static final Matcher<ExpressionTree> METHOD_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{GUAVA_BYTE_STREAM_COPY_MATCHER, APACHE_COMMONS_BYTE_STREAM_COPY_MATCHER, AWS_BYTE_STREAM_COPY_MATCHER});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (METHOD_MATCHER.matches((Tree)tree, state)) {
            List<? extends ExpressionTree> args = tree.getArguments();
            if (args.size() != 2) {
                return Description.NO_MATCH;
            }
            ExpressionTree maybeInputStreamArg = args.get(0);
            ExpressionTree maybeOutputStreamArg = args.get(1);
            if (INPUT_STREAM_MATCHER.matches((Tree)maybeInputStreamArg, state) && OUTPUT_STREAM_MATCHER.matches((Tree)maybeOutputStreamArg, state)) {
                String inputStreamArg = state.getSourceForNode((Tree)maybeInputStreamArg);
                String outputStreamArg = state.getSourceForNode((Tree)maybeOutputStreamArg);
                if (inputStreamArg == null || outputStreamArg == null) {
                    return Description.NO_MATCH;
                }
                if (maybeInputStreamArg instanceof IdentifierTree && ((IdentifierTree)maybeInputStreamArg).getName().contentEquals("this")) {
                    inputStreamArg = "super";
                }
                String replacement = inputStreamArg + ".transferTo(" + outputStreamArg + ")";
                SuggestedFix fix = SuggestedFix.builder().replace((Tree)tree, replacement).build();
                return this.buildDescription(tree).setMessage(ERROR_MESSAGE).addFix((Fix)fix).build();
            }
        }
        return Description.NO_MATCH;
    }
}

