/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, altNames={"rawtypes"}, summary="Avoid raw types; add appropriate type parameters if possible.\nThis can be suppressed with @SuppressWarnings(\"rawtypes\") where necessary, such as when interacting with older library code.")
@AutoService(value={BugChecker.class})
public final class RawTypes
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.TypeCastTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.testType(tree.getType(), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.testType(tree.getIdentifier(), state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        Description extendsResult = this.testType(tree.getExtendsClause(), state);
        if (extendsResult != Description.NO_MATCH) {
            return extendsResult;
        }
        return this.testTypes(tree.getImplementsClause(), state);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.testType(tree.getReturnType(), state);
    }

    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        return this.testType(tree.getType(), state);
    }

    private Description testTypes(Iterable<? extends Tree> types, VisitorState state) {
        for (Tree tree : types) {
            Description description = this.testType(tree, state);
            if (description == Description.NO_MATCH) continue;
            return description;
        }
        return Description.NO_MATCH;
    }

    private Description testType(Tree type, VisitorState state) {
        if (type == null) {
            return Description.NO_MATCH;
        }
        Type realType = ASTHelpers.getType((Tree)type);
        if (realType != null && realType.isRaw()) {
            if (state.getEndPosition(type) < 0) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(type).setMessage("Avoid raw types; add appropriate type parameters if possible. The type was: " + SuggestedFixes.prettyType(null, null, (Type)realType) + "\nThis can be suppressed with @SuppressWarnings(\"rawtypes\") where necessary, such as when interacting with older library code.").build();
        }
        if (type.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            return this.testTypes(((ParameterizedTypeTree)type).getTypeArguments(), state);
        }
        return Description.NO_MATCH;
    }
}

