/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone.safety;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.dataflow.AccessPath;
import com.google.errorprone.dataflow.AccessPathStore;
import com.google.errorprone.dataflow.AccessPathValues;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.MoreASTHelpers;
import com.palantir.baseline.errorprone.Records;
import com.palantir.baseline.errorprone.safety.Safety;
import com.palantir.baseline.errorprone.safety.SafetyAnnotations;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Name;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.errorprone.dataflow.analysis.ForwardAnalysisImpl;
import org.checkerframework.errorprone.dataflow.analysis.ForwardTransferFunction;
import org.checkerframework.errorprone.dataflow.analysis.RegularTransferResult;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.analysis.TransferInput;
import org.checkerframework.errorprone.dataflow.analysis.TransferResult;
import org.checkerframework.errorprone.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.errorprone.dataflow.cfg.UnderlyingAST;
import org.checkerframework.errorprone.dataflow.cfg.builder.CFGBuilder;
import org.checkerframework.errorprone.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ArrayTypeNode;
import org.checkerframework.errorprone.dataflow.cfg.node.AssertionErrorNode;
import org.checkerframework.errorprone.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.errorprone.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.errorprone.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.errorprone.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.errorprone.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.errorprone.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.CaseNode;
import org.checkerframework.errorprone.dataflow.cfg.node.CharacterLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ClassDeclarationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.errorprone.dataflow.cfg.node.DeconstructorPatternNode;
import org.checkerframework.errorprone.dataflow.cfg.node.DoubleLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.EqualToNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ExplicitThisNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ExpressionStatementNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FloatLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.errorprone.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.errorprone.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ImplicitThisNode;
import org.checkerframework.errorprone.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.errorprone.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LambdaResultExpressionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LessThanNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LongLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.MarkerNode;
import org.checkerframework.errorprone.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.errorprone.dataflow.cfg.node.NullChkNode;
import org.checkerframework.errorprone.dataflow.cfg.node.NullLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.errorprone.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.errorprone.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.PackageNameNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ParameterizedTypeNode;
import org.checkerframework.errorprone.dataflow.cfg.node.PrimitiveTypeNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ReturnNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ShortLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.errorprone.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.errorprone.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.StringLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.SuperNode;
import org.checkerframework.errorprone.dataflow.cfg.node.SwitchExpressionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.errorprone.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.ThrowNode;
import org.checkerframework.errorprone.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.errorprone.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.errorprone.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.errorprone.javacutil.TreePathUtil;

public final class SafetyPropagationTransfer
implements ForwardTransferFunction<Safety, AccessPathStore<Safety>> {
    private static final Matcher<Tree> THROWABLE_SUBTYPE = Matchers.isSubtypeOf(Throwable.class);
    private static final Matcher<ExpressionTree> TO_STRING = MethodMatchers.instanceMethod().anyClass().named("toString").withNoParameters();
    private static final Matcher<ExpressionTree> THROWABLE_GET_MESSAGE = MethodMatchers.instanceMethod().onDescendantOf(Throwable.class.getName()).namedAnyOf(new String[]{"getMessage", "getLocalizedMessage"}).withNoParameters();
    private static final Matcher<ExpressionTree> STRING_FORMAT = MethodMatchers.staticMethod().onClass(String.class.getName()).named("format");
    private static final Matcher<ExpressionTree> STRING_VALUE_OF = MethodMatchers.staticMethod().onClass(String.class.getName()).named("valueOf");
    private static final Matcher<ExpressionTree> STRING_COPY_VALUE_OF = MethodMatchers.staticMethod().onClass(String.class.getName()).named("copyValueOf");
    private static final Matcher<ExpressionTree> OBJECTS_TO_STRING = MethodMatchers.staticMethod().onClass(Objects.class.getName()).named("toString");
    private static final Matcher<ExpressionTree> IMMUTABLE_COLLECTION_FACTORY = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{ImmutableList.class.getName(), ImmutableSet.class.getName(), ImmutableSortedSet.class.getName(), ImmutableMap.class.getName(), ImmutableListMultimap.class.getName(), ImmutableSetMultimap.class.getName(), List.class.getName(), Set.class.getName(), Map.class.getName()}).namedAnyOf(new String[]{"of", "copyOf"}), MethodMatchers.staticMethod().onClass(Arrays.class.getName()).named("asList")});
    private static final Matcher<ExpressionTree> OPTIONAL_FACTORIES = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(Optional.class.getName()).namedAnyOf(new String[]{"of", "ofNullable"}), MethodMatchers.staticMethod().onClassAny(new String[]{OptionalInt.class.getName(), OptionalLong.class.getName(), OptionalDouble.class.getName()}).named("of")});
    private static final Matcher<ExpressionTree> STATIC_STREAM_FACTORIES = MethodMatchers.staticMethod().onClass(Stream.class.getName()).namedAnyOf(new String[]{"of", "ofNullable", "concat"});
    private static final Matcher<ExpressionTree> RID_FACTORY = MethodMatchers.staticMethod().onClass("com.palantir.ri.ResourceIdentifier").namedAnyOf(new String[]{"of", "valueOf"});
    private static final Matcher<ExpressionTree> THROWABLES_STACK_TRACE_AS_STRING = MethodMatchers.staticMethod().onClass("com.google.common.base.Throwables").named("getStackTraceAsString").withParameters(Throwable.class.getName(), new String[0]);
    private static final Matcher<ExpressionTree> PRIMITIVE_BOXING = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(Boolean.class.getName()).named("valueOf").withParameters("boolean", new String[0]), MethodMatchers.staticMethod().onClass(Integer.class.getName()).named("valueOf").withParameters("int", new String[0]), MethodMatchers.staticMethod().onClass(Byte.class.getName()).named("valueOf").withParameters("byte", new String[0]), MethodMatchers.staticMethod().onClass(Character.class.getName()).named("valueOf").withParameters("char", new String[0]), MethodMatchers.staticMethod().onClass(Double.class.getName()).named("valueOf").withParameters("double", new String[0]), MethodMatchers.staticMethod().onClass(Float.class.getName()).named("valueOf").withParameters("float", new String[0]), MethodMatchers.staticMethod().onClass(Long.class.getName()).named("valueOf").withParameters("long", new String[0]), MethodMatchers.staticMethod().onClass(Short.class.getName()).named("valueOf").withParameters("short", new String[0])});
    private static final Matcher<ExpressionTree> PRIMITIVE_UNBOXING = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass(Boolean.class.getName()).named("booleanValue").withNoParameters(), MethodMatchers.instanceMethod().onExactClass(Integer.class.getName()).named("intValue").withNoParameters(), MethodMatchers.instanceMethod().onExactClass(Byte.class.getName()).named("byteValue").withNoParameters(), MethodMatchers.instanceMethod().onExactClass(Character.class.getName()).named("charValue").withNoParameters(), MethodMatchers.instanceMethod().onExactClass(Double.class.getName()).named("doubleValue").withNoParameters(), MethodMatchers.instanceMethod().onExactClass(Float.class.getName()).named("floatValue").withNoParameters(), MethodMatchers.instanceMethod().onExactClass(Long.class.getName()).named("longValue").withNoParameters(), MethodMatchers.instanceMethod().onExactClass(Short.class.getName()).named("shortValue").withNoParameters()});
    private static final Matcher<ExpressionTree> RETURNS_SAFETY_COMBINATION_OF_ARGS = Matchers.anyOf((Matcher[])new Matcher[]{STRING_FORMAT, STRING_VALUE_OF, STRING_COPY_VALUE_OF, OBJECTS_TO_STRING, IMMUTABLE_COLLECTION_FACTORY, OPTIONAL_FACTORIES, STATIC_STREAM_FACTORIES, RID_FACTORY, THROWABLES_STACK_TRACE_AS_STRING, PRIMITIVE_BOXING});
    private static final Matcher<ExpressionTree> CONSTRUCTOR_SAFETY_COMBINATION_OF_ARGS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(StringBuilder.class.getName()).withParameters(String.class.getName(), new String[0]), MethodMatchers.constructor().forClass(StringBuilder.class.getName()).withParameters(CharSequence.class.getName(), new String[0]), MethodMatchers.constructor().forClass(StringBuffer.class.getName()).withParameters(String.class.getName(), new String[0]), MethodMatchers.constructor().forClass(StringBuffer.class.getName()).withParameters(CharSequence.class.getName(), new String[0])});
    private static final Matcher<ExpressionTree> OPTIONAL_ACCESSORS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(Optional.class.getName()).namedAnyOf(new String[]{"filter", "get", "orElseThrow", "stream"}), MethodMatchers.instanceMethod().onDescendantOf(OptionalInt.class.getName()).namedAnyOf(new String[]{"getAsInt", "orElseThrow"}), MethodMatchers.instanceMethod().onDescendantOf(OptionalLong.class.getName()).namedAnyOf(new String[]{"getAsLong", "orElseThrow"}), MethodMatchers.instanceMethod().onDescendantOf(OptionalDouble.class.getName()).namedAnyOf(new String[]{"getAsDouble", "orElseThrow"})});
    private static final Matcher<ExpressionTree> STREAM_ACCESSORS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(BaseStream.class.getName()).namedAnyOf(new String[]{"iterator", "spliterator", "sequential", "parallel", "unordered", "onClose"}), MethodMatchers.instanceMethod().onDescendantOf(Stream.class.getName()).namedAnyOf(new String[]{"filter", "distinct", "sorted", "peek", "limit", "skip", "takeWhile", "dropWhile", "toArray", "toList", "min", "max", "findFirst", "findAny"})});
    private static final Matcher<ExpressionTree> RETURNS_SAFETY_OF_RECEIVER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(CharSequence.class.getName()).namedAnyOf(new String[]{"charAt", "subSequence", "chars", "codePoints"}), MethodMatchers.instanceMethod().onExactClass(String.class.getName()).namedAnyOf(new String[]{"getBytes", "toLowerCase", "toUpperCase", "substring", "split", "toCharArray"}), MethodMatchers.instanceMethod().onDescendantOf(Collection.class.getName()).namedAnyOf(new String[]{"toArray", "stream", "parallelStream"}), MethodMatchers.instanceMethod().onDescendantOf(Iterable.class.getName()).namedAnyOf(new String[]{"toArray", "iterator", "spliterator"}), MethodMatchers.instanceMethod().onDescendantOf(Iterator.class.getName()).named("next").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf("com.palantir.ri.ResourceIdentifier").named("getLocator").withNoParameters(), OPTIONAL_ACCESSORS, STREAM_ACCESSORS, THROWABLE_GET_MESSAGE, PRIMITIVE_UNBOXING});
    private static final Matcher<ExpressionTree> RETURNS_SAFETY_OF_FIRST_ARG = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(Objects.class.getName()).named("requireNonNull"), MethodMatchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), MethodMatchers.staticMethod().onClass("com.palantir.logsafe.Preconditions").namedAnyOf(new String[]{"checkNotNull", "checkArgumentNotNull"})});
    private static final Matcher<ExpressionTree> MUTABLE_BUILDER_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClassAny(new String[]{StringBuilder.class.getName(), StringBuffer.class.getName()}).namedAnyOf(new String[]{"append", "insert", "replace"})});
    private static final Matcher<ExpressionTree> UNKNOWN_COLLECTORS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(Collectors.class.getName()).named("counting").withNoParameters(), MethodMatchers.staticMethod().onClass(Collectors.class.getName()).namedAnyOf(new String[]{"toMap", "toUnmodifiableMap", "toConcurrentMap"}), MethodMatchers.staticMethod().onClass(ImmutableMap.class.getName()).named("toImmutableMap"), MethodMatchers.staticMethod().onClass(ImmutableBiMap.class.getName()).named("toImmutableBiMap")});
    private static final Matcher<ExpressionTree> COLLECT_INCLUDES_STREAM_SAFETY = Matchers.methodInvocation((Matcher)MethodMatchers.instanceMethod().onDescendantOf(Stream.class.getName()).namedAnyOf(new String[]{"collect"}), (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.LAST, (Matcher)Matchers.not(UNKNOWN_COLLECTORS));
    private static final Matcher<ExpressionTree> RETURNS_SAFETY_OF_ARGS_AND_RECEIVER = Matchers.anyOf((Matcher[])new Matcher[]{COLLECT_INCLUDES_STREAM_SAFETY, MethodMatchers.instanceMethod().onDescendantOf(Optional.class.getName()).named("orElse"), MUTABLE_BUILDER_METHODS});
    private VisitorState state;
    private final Set<Symbol.VarSymbol> traversed = new HashSet<Symbol.VarSymbol>();

    public AccessPathStore<Safety> initialStore(UnderlyingAST _underlyingAst, List<LocalVariableNode> parameters) {
        if (parameters == null) {
            return AccessPathStore.empty();
        }
        AccessPathStore.Builder result = AccessPathStore.empty().toBuilder();
        for (LocalVariableNode param : parameters) {
            Safety declared = SafetyAnnotations.getSafety(param.getTree(), this.state);
            result.setInformation(AccessPath.fromLocalVariable((LocalVariableNode)param), (AbstractValue)declared);
        }
        return result.build();
    }

    public ClearVisitorState setVisitorState(VisitorState value) {
        this.state = Objects.requireNonNull(value, "VisitorState");
        this.traversed.clear();
        return new ClearVisitorState();
    }

    @CheckReturnValue
    private static TransferResult<Safety, AccessPathStore<Safety>> noStoreChanges(Safety value, TransferInput<?, AccessPathStore<Safety>> input) {
        return new RegularTransferResult((AbstractValue)value, (Store)((AccessPathStore)input.getRegularStore()));
    }

    @CheckReturnValue
    private static TransferResult<Safety, AccessPathStore<Safety>> updateRegularStore(Safety value, TransferInput<?, AccessPathStore<Safety>> input, ReadableUpdates updates) {
        ResultingStore newStore = SafetyPropagationTransfer.updateStore((AccessPathStore<Safety>)((AccessPathStore)input.getRegularStore()), updates);
        return new RegularTransferResult((AbstractValue)value, newStore.store, newStore.storeChanged);
    }

    @CheckReturnValue
    private static TransferResult<Safety, AccessPathStore<Safety>> conditionalResult(Safety value, AccessPathStore<Safety> thenStore, AccessPathStore<Safety> elseStore, boolean storeChanged) {
        return new ConditionalTransferResult((AbstractValue)value, thenStore, elseStore, storeChanged);
    }

    @CheckReturnValue
    private static ResultingStore updateStore(AccessPathStore<Safety> oldStore, ReadableUpdates update) {
        AccessPathStore.Builder builder = oldStore.toBuilder();
        update.values.forEach((arg_0, arg_1) -> ((AccessPathStore.Builder)builder).setInformation(arg_0, arg_1));
        AccessPathStore newStore = builder.build();
        return new ResultingStore((AccessPathStore<Safety>)newStore, !newStore.equals(oldStore));
    }

    private static TransferResult<Safety, AccessPathStore<Safety>> unknown(TransferInput<?, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.noStoreChanges(Safety.UNKNOWN, input);
    }

    private TransferResult<Safety, AccessPathStore<Safety>> literal(TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.noStoreChanges(Safety.SAFE, input);
    }

    private TransferResult<Safety, AccessPathStore<Safety>> unary(UnaryOperationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety safety = SafetyPropagationTransfer.getValueOfSubNode(input, node.getOperand());
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    private TransferResult<Safety, AccessPathStore<Safety>> binary(BinaryOperationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety safety = (Safety)SafetyPropagationTransfer.getValueOfSubNode(input, node.getLeftOperand()).leastUpperBound(SafetyPropagationTransfer.getValueOfSubNode(input, node.getRightOperand()));
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitShortLiteral(ShortLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitIntegerLiteral(IntegerLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitLongLiteral(LongLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitFloatLiteral(FloatLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitDoubleLiteral(DoubleLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitBooleanLiteral(BooleanLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitCharacterLiteral(CharacterLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitStringLiteral(StringLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNullLiteral(NullLiteralNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.literal(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNumericalMinus(NumericalMinusNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.unary((UnaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNumericalPlus(NumericalPlusNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.unary((UnaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitBitwiseComplement(BitwiseComplementNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.unary((UnaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNullChk(NullChkNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.noStoreChanges(Safety.SAFE, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitStringConcatenate(StringConcatenateNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNumericalAddition(NumericalAdditionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNumericalSubtraction(NumericalSubtractionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNumericalMultiplication(NumericalMultiplicationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitIntegerDivision(IntegerDivisionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitFloatingDivision(FloatingDivisionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitIntegerRemainder(IntegerRemainderNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitFloatingRemainder(FloatingRemainderNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitLeftShift(LeftShiftNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitSignedRightShift(SignedRightShiftNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitUnsignedRightShift(UnsignedRightShiftNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitBitwiseAnd(BitwiseAndNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitBitwiseOr(BitwiseOrNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitBitwiseXor(BitwiseXorNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.binary((BinaryOperationNode)node, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitLessThan(LessThanNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.noStoreChanges(Safety.SAFE, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitLessThanOrEqual(LessThanOrEqualNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.noStoreChanges(Safety.SAFE, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitGreaterThan(GreaterThanNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.noStoreChanges(Safety.SAFE, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitGreaterThanOrEqual(GreaterThanOrEqualNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.conditionalResult(Safety.SAFE, (AccessPathStore<Safety>)((AccessPathStore)input.getThenStore()), (AccessPathStore<Safety>)((AccessPathStore)input.getElseStore()), false);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitEqualTo(EqualToNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.conditionalResult(Safety.SAFE, (AccessPathStore<Safety>)((AccessPathStore)input.getThenStore()), (AccessPathStore<Safety>)((AccessPathStore)input.getElseStore()), false);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNotEqual(NotEqualNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.conditionalResult(Safety.SAFE, (AccessPathStore<Safety>)((AccessPathStore)input.getThenStore()), (AccessPathStore<Safety>)((AccessPathStore)input.getElseStore()), false);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitConditionalAnd(ConditionalAndNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.conditionalResult(Safety.SAFE, (AccessPathStore<Safety>)((AccessPathStore)input.getThenStore()), (AccessPathStore<Safety>)((AccessPathStore)input.getElseStore()), false);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitConditionalOr(ConditionalOrNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.conditionalResult(Safety.SAFE, (AccessPathStore<Safety>)((AccessPathStore)input.getThenStore()), (AccessPathStore<Safety>)((AccessPathStore)input.getElseStore()), false);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitConditionalNot(ConditionalNotNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.conditionalResult(Safety.SAFE, (AccessPathStore<Safety>)((AccessPathStore)input.getElseStore()), (AccessPathStore<Safety>)((AccessPathStore)input.getThenStore()), !((AccessPathStore)input.getThenStore()).equals(input.getElseStore()));
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitTernaryExpression(TernaryExpressionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety safety = (Safety)SafetyPropagationTransfer.getValueOfSubNode(input, node.getThenOperand()).leastUpperBound(SafetyPropagationTransfer.getValueOfSubNode(input, node.getElseOperand()));
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitSwitchExpressionNode(SwitchExpressionNode _node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitAssignment(AssignmentNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Safety expressionSafety = SafetyPropagationTransfer.getValueOfSubNode(input, node.getExpression());
        Safety targetSafety = SafetyAnnotations.getSafety(node.getTarget().getTree(), this.state);
        Safety safety = Safety.mergeAssumingUnknownIsSame(expressionSafety, targetSafety);
        Node target = node.getTarget();
        if (target instanceof LocalVariableNode) {
            updates.trySet(target, safety);
        } else if (target instanceof ArrayAccessNode) {
            Node arrayNode = ((ArrayAccessNode)target).getArray();
            Safety arrayNodeSafety = SafetyPropagationTransfer.getValueOfSubNode(input, arrayNode);
            safety = arrayNodeSafety == null ? safety : (Safety)arrayNodeSafety.leastUpperBound(safety);
            updates.trySet(arrayNode, safety);
        } else if (target instanceof FieldAccessNode) {
            FieldAccessNode fieldAccess = (FieldAccessNode)target;
            updates.set(fieldAccess, safety);
        } else {
            throw new UnsupportedOperationException("Safety analysis bug, unknown target type: " + target.getClass() + " with value: " + target);
        }
        return SafetyPropagationTransfer.updateRegularStore(safety, input, updates);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitLocalVariable(LocalVariableNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        if (SafetyPropagationTransfer.hasNonNullConstantValue(node)) {
            return SafetyPropagationTransfer.noStoreChanges(Safety.SAFE, input);
        }
        AccessPath accessPath = AccessPath.fromLocalVariable((LocalVariableNode)node);
        Safety safety = (Safety)((AccessPathStore)input.getRegularStore()).valueOfAccessPath(accessPath, null);
        if (safety == null) {
            safety = THROWABLE_SUBTYPE.matches(node.getTree(), this.state) ? (Safety)Safety.UNSAFE.leastUpperBound(SafetyAnnotations.getSafety(node.getTree(), this.state)) : (SafetyPropagationTransfer.isPatternBinding(node, this.state) ? SafetyAnnotations.getSafety(node.getTree(), this.state) : this.getCapturedLocalVariableSafety(node));
        }
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    private static boolean isPatternBinding(LocalVariableNode node, VisitorState state) {
        TreePath varPath = TreePath.getPath(state.getPath().getCompilationUnit(), node.getTree());
        if (varPath == null) {
            return false;
        }
        TreePath parentPath = varPath.getParentPath();
        if (parentPath == null) {
            return false;
        }
        Tree enclosing = parentPath.getLeaf();
        if (enclosing == null) {
            return false;
        }
        String kindString = enclosing.getKind().name();
        return "BINDING_PATTERN".equals(kindString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Safety getCapturedLocalVariableSafety(LocalVariableNode node) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)node.getTree());
        if (!(symbol instanceof Symbol.VarSymbol)) {
            return Safety.UNKNOWN;
        }
        Symbol.VarSymbol variableSymbol = (Symbol.VarSymbol)symbol;
        JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(this.state.context);
        TreePath variableDefinition = Trees.instance(javacEnv).getPath(variableSymbol);
        if (variableDefinition == null) {
            return Safety.UNKNOWN;
        }
        TreePath enclosingPath = TreePathUtil.pathTillOfKind((TreePath)variableDefinition, EnumSet.of(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION));
        if (enclosingPath == null) {
            return Safety.UNKNOWN;
        }
        if (!this.traversed.add(variableSymbol)) {
            return Safety.UNKNOWN;
        }
        try {
            UnderlyingAST ast = SafetyPropagationTransfer.createAst(enclosingPath);
            ControlFlowGraph cfg = CFGBuilder.build((CompilationUnitTree)this.state.getPath().getCompilationUnit(), (UnderlyingAST)ast, (boolean)false, (boolean)false, (ProcessingEnvironment)javacEnv);
            ForwardAnalysisImpl analysis = new ForwardAnalysisImpl((ForwardTransferFunction)this);
            analysis.performAnalysis(cfg);
            Safety maybeResult = (Safety)analysis.getValue(variableDefinition.getLeaf());
            Safety safety = maybeResult == null ? Safety.UNKNOWN : maybeResult;
            return safety;
        }
        finally {
            this.traversed.remove(variableSymbol);
        }
    }

    private static UnderlyingAST createAst(TreePath path) {
        Tree tree = path.getLeaf();
        ClassTree enclosingClass = TreePathUtil.enclosingClass((TreePath)path);
        if (tree instanceof MethodTree) {
            return new UnderlyingAST.CFGMethod((MethodTree)tree, enclosingClass);
        }
        if (tree instanceof LambdaExpressionTree) {
            return new UnderlyingAST.CFGLambda((LambdaExpressionTree)tree, enclosingClass, TreePathUtil.enclosingMethod((TreePath)path));
        }
        return new UnderlyingAST.CFGStatement(tree, enclosingClass);
    }

    private static boolean hasNonNullConstantValue(LocalVariableNode node) {
        VariableElement element = node.getElement();
        return element != null && element.getConstantValue() != null;
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitVariableDeclaration(VariableDeclarationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety variableTypeSafety = SafetyAnnotations.getSafety(node.getTree().getType(), this.state);
        Safety variableSafety = SafetyAnnotations.getSafety(node.getTree(), this.state);
        Safety safety = Safety.mergeAssumingUnknownIsSame(variableTypeSafety, variableSafety);
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitFieldAccess(FieldAccessNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety fieldSafety = SafetyAnnotations.getSafety(node.getTree(), this.state);
        Symbol.VarSymbol symbol = (Symbol.VarSymbol)ASTHelpers.getSymbol((Tree)node.getTree());
        AccessPath maybeAccessPath = AccessPath.fromFieldAccess((FieldAccessNode)node);
        Safety flowSafety = this.fieldSafety(symbol, maybeAccessPath, (AccessPathValues<Safety>)((AccessPathValues)input.getRegularStore()));
        Safety safety = Safety.mergeAssumingUnknownIsSame(fieldSafety, flowSafety);
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    private Safety fieldSafety(@Nullable Symbol.VarSymbol accessed, @Nullable AccessPath path, AccessPathValues<Safety> store) {
        if (accessed == null) {
            return Safety.UNKNOWN;
        }
        Safety maybeFlowComputedSafety = path == null ? null : (Safety)((Object)store.valueOfAccessPath(path, null));
        Safety flowSafety = maybeFlowComputedSafety == null ? Safety.UNKNOWN : maybeFlowComputedSafety;
        Safety symbolSafety = SafetyAnnotations.getSafety(accessed, this.state);
        Safety typeSafety = SafetyAnnotations.getSafety(accessed.type.tsym, this.state);
        Safety symbolAndTypeSafety = Safety.mergeAssumingUnknownIsSame(flowSafety, symbolSafety, typeSafety);
        if (((Name)accessed.getSimpleName()).contentEquals("class")) {
            return Safety.mergeAssumingUnknownIsSame(symbolAndTypeSafety, Safety.SAFE);
        }
        if (accessed.isEnum()) {
            return Safety.mergeAssumingUnknownIsSame(symbolAndTypeSafety, Safety.SAFE);
        }
        if (accessed.getConstValue() != null) {
            return Safety.mergeAssumingUnknownIsSame(symbolAndTypeSafety, Safety.SAFE);
        }
        if (maybeFlowComputedSafety == null) {
            Safety initializer = this.fieldInitializerSafetyIfAvailable(accessed);
            if ((accessed.flags_field & 0x10L) != 0L || initializer == Safety.DO_NOT_LOG || initializer == Safety.UNSAFE) {
                return Safety.mergeAssumingUnknownIsSame(symbolAndTypeSafety, initializer);
            }
        }
        return symbolAndTypeSafety;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Safety fieldInitializerSafetyIfAvailable(Symbol.VarSymbol accessed) {
        if (!this.traversed.add(accessed)) {
            return Safety.UNKNOWN;
        }
        try {
            JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(this.state.context);
            TreePath fieldDeclPath = Trees.instance(javacEnv).getPath(accessed);
            if (fieldDeclPath == null || fieldDeclPath.getCompilationUnit() != this.state.getPath().getCompilationUnit() || !(fieldDeclPath.getLeaf() instanceof VariableTree)) {
                Safety safety = Safety.UNKNOWN;
                return safety;
            }
            ExpressionTree initializer = ((VariableTree)fieldDeclPath.getLeaf()).getInitializer();
            if (initializer == null) {
                Safety safety = Safety.UNKNOWN;
                return safety;
            }
            ClassTree classTree = (ClassTree)fieldDeclPath.getParentPath().getLeaf();
            TreePath initializerPath = TreePath.getPath(fieldDeclPath, (Tree)initializer);
            UnderlyingAST.CFGStatement ast = new UnderlyingAST.CFGStatement(initializerPath.getLeaf(), classTree);
            ControlFlowGraph cfg = CFGBuilder.build((TreePath)initializerPath, (UnderlyingAST)ast, (boolean)false, (boolean)false, (ProcessingEnvironment)javacEnv);
            ForwardAnalysisImpl analysis = new ForwardAnalysisImpl((ForwardTransferFunction)this);
            analysis.performAnalysis(cfg);
            Safety maybeResult = (Safety)analysis.getValue(initializerPath.getLeaf());
            Safety safety = maybeResult == null ? Safety.UNKNOWN : maybeResult;
            return safety;
        }
        finally {
            this.traversed.remove(accessed);
        }
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitMethodAccess(MethodAccessNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitArrayAccess(ArrayAccessNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitImplicitThis(ImplicitThisNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)node.getTree());
        Safety safety = symbol == null ? Safety.UNKNOWN : SafetyAnnotations.getSafety(symbol.owner, this.state);
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitExplicitThis(ExplicitThisNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)node.getTree());
        Safety safety = symbol == null ? Safety.UNKNOWN : SafetyAnnotations.getSafety(symbol.owner, this.state);
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitSuper(SuperNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)node.getTree());
        Safety safety = symbol == null ? Safety.UNKNOWN : SafetyAnnotations.getSafety(symbol.owner, this.state);
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitReturn(ReturnNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Node result = node.getResult();
        Safety safety = result == null ? Safety.SAFE : SafetyPropagationTransfer.getValueOfSubNode(input, result);
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitLambdaResultExpression(LambdaResultExpressionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitStringConversion(StringConversionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety safety = SafetyPropagationTransfer.getValueOfSubNode(input, node.getOperand());
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitWideningConversion(WideningConversionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.handleTypeConversion(node.getTree(), node.getOperand(), input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitNarrowingConversion(NarrowingConversionNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return this.handleTypeConversion(node.getTree(), node.getOperand(), input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitTypeCast(TypeCastNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        TypeCastTree castTree = node.getTree();
        return this.handleTypeConversion(castTree.getType(), node.getOperand(), input);
    }

    private TransferResult<Safety, AccessPathStore<Safety>> handleTypeConversion(Tree newType, Node original, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.noStoreChanges(this.getTypeConversionSafety(newType, original, input), input);
    }

    private Safety getTypeConversionSafety(Tree newType, Node original, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety inputSafety = SafetyPropagationTransfer.getValueOfSubNode(input, original);
        Safety targetSafety = SafetyAnnotations.getSafety(newType, this.state);
        Safety resultSafety = !targetSafety.allowsValueWith(inputSafety) && ASTHelpers.isSubtype((Type)MoreASTHelpers.getResultType(newType), (Type)MoreASTHelpers.getResultType(original.getTree()), (VisitorState)this.state) ? targetSafety : Safety.mergeAssumingUnknownIsSame(inputSafety, targetSafety);
        return resultSafety;
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitInstanceOf(InstanceOfNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        List bindingVariables = node.getBindingVariables();
        Node patternNode = node.getPatternNode();
        if (patternNode instanceof LocalVariableNode && bindingVariables.size() == 1) {
            Safety safety = this.getTypeConversionSafety(node.getTree().getType(), node.getOperand(), input);
            thenUpdates.set((LocalVariableNode)bindingVariables.get(0), safety);
        }
        ResultingStore thenStore = SafetyPropagationTransfer.updateStore((AccessPathStore<Safety>)((AccessPathStore)input.getThenStore()), thenUpdates);
        return new ConditionalTransferResult((AbstractValue)Safety.SAFE, thenStore.store, (Store)((AccessPathStore)input.getElseStore()), thenStore.storeChanged);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitSynchronized(SynchronizedNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitAssertionError(AssertionErrorNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitThrow(ThrowNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitCase(CaseNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitMethodInvocation(MethodInvocationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety methodSymbolSafety = this.getMethodSymbolSafety(node, input);
        Safety knownMethodSafety = this.getKnownMethodSafety(node, input);
        Safety result = Safety.mergeAssumingUnknownIsSame(methodSymbolSafety, knownMethodSafety);
        if (MUTABLE_BUILDER_METHODS.matches((Tree)node.getTree(), this.state)) {
            MethodInvocationNode currentInvocation;
            ReadableUpdates updates = new ReadableUpdates();
            Node current = node.getTarget().getReceiver();
            while (current instanceof MethodInvocationNode && MUTABLE_BUILDER_METHODS.matches((Tree)(currentInvocation = (MethodInvocationNode)current).getTree(), this.state)) {
                current = currentInvocation.getTarget().getReceiver();
            }
            updates.trySet(current, result);
            return SafetyPropagationTransfer.updateRegularStore(result, input, updates);
        }
        return SafetyPropagationTransfer.noStoreChanges(result, input);
    }

    private Safety getKnownMethodSafety(MethodInvocationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        if (RETURNS_SAFETY_OF_ARGS_AND_RECEIVER.matches((Tree)node.getTree(), this.state)) {
            Safety safety = SafetyPropagationTransfer.getValueOfSubNode(input, node.getTarget().getReceiver());
            for (Node argument : node.getArguments()) {
                safety = (Safety)safety.leastUpperBound(SafetyPropagationTransfer.getValueOfSubNode(input, argument));
            }
            return safety;
        }
        if (RETURNS_SAFETY_COMBINATION_OF_ARGS.matches((Tree)node.getTree(), this.state)) {
            Safety safety = Safety.SAFE;
            for (Node argument : node.getArguments()) {
                safety = (Safety)safety.leastUpperBound(SafetyPropagationTransfer.getValueOfSubNode(input, argument));
            }
            return safety;
        }
        if (RETURNS_SAFETY_OF_RECEIVER.matches((Tree)node.getTree(), this.state)) {
            return SafetyPropagationTransfer.getValueOfSubNode(input, node.getTarget().getReceiver());
        }
        if (RETURNS_SAFETY_OF_FIRST_ARG.matches((Tree)node.getTree(), this.state)) {
            return SafetyPropagationTransfer.getValueOfSubNode(input, (Node)node.getArguments().get(0));
        }
        return Safety.UNKNOWN;
    }

    private Safety getMethodSymbolSafety(MethodInvocationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety methodSafety = SafetyAnnotations.getSafety(node.getTree(), this.state);
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)node.getTree());
        if (methodSymbol != null) {
            if (methodSafety == Safety.UNKNOWN && TO_STRING.matches((Tree)node.getTree(), this.state)) {
                return SafetyPropagationTransfer.getValueOfSubNode(input, node.getTarget().getReceiver());
            }
            return methodSafety;
        }
        return methodSafety;
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitObjectCreation(ObjectCreationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety result = SafetyAnnotations.getSafety(node.getTree(), this.state);
        if (CONSTRUCTOR_SAFETY_COMBINATION_OF_ARGS.matches((Tree)node.getTree(), this.state)) {
            Safety safety = Safety.SAFE;
            for (Node argument : node.getArguments()) {
                safety = (Safety)safety.leastUpperBound(SafetyPropagationTransfer.getValueOfSubNode(input, argument));
            }
            result = Safety.mergeAssumingUnknownIsSame(result, safety);
        }
        return SafetyPropagationTransfer.noStoreChanges(result, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitMemberReference(FunctionalInterfaceNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitArrayCreation(ArrayCreationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        Safety safety = Safety.SAFE;
        for (Node item : node.getInitializers()) {
            safety = (Safety)safety.leastUpperBound(SafetyPropagationTransfer.getValueOfSubNode(input, item));
        }
        return SafetyPropagationTransfer.noStoreChanges(safety, input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitArrayType(ArrayTypeNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitPrimitiveType(PrimitiveTypeNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitClassName(ClassNameNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitPackageName(PackageNameNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitParameterizedType(ParameterizedTypeNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitMarker(MarkerNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitClassDeclaration(ClassDeclarationNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitExpressionStatement(ExpressionStatementNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        return SafetyPropagationTransfer.unknown(input);
    }

    public TransferResult<Safety, AccessPathStore<Safety>> visitDeconstructorPattern(DeconstructorPatternNode node, TransferInput<Safety, AccessPathStore<Safety>> input) {
        TypeMirror type = node.getType();
        if (type instanceof Type.ClassType) {
            Type.ClassType classType = (Type.ClassType)type;
            Symbol.ClassSymbol symbol = (Symbol.ClassSymbol)classType.tsym;
            if (ASTHelpers.isRecord((Symbol)symbol)) {
                List<Symbol.VarSymbol> recordComponents = Records.getRecordComponents(symbol);
                List nestedPatterns = node.getNestedPatterns();
                if (recordComponents.size() == nestedPatterns.size() && !recordComponents.isEmpty()) {
                    ReadableUpdates updates = new ReadableUpdates();
                    for (int i = 0; i < recordComponents.size(); ++i) {
                        Symbol.VarSymbol recordComponent = recordComponents.get(i);
                        Node pattern = (Node)nestedPatterns.get(i);
                        Safety existing = SafetyPropagationTransfer.getValueOfSubNode(input, pattern);
                        Safety recordComponentSafety = Safety.mergeAssumingUnknownIsSame(SafetyAnnotations.getSafety(recordComponent, this.state), SafetyAnnotations.getSafety(recordComponent.type, this.state), SafetyAnnotations.getSafety(recordComponent.type, this.state));
                        updates.trySet(pattern, Safety.mergeAssumingUnknownIsSame(existing, recordComponentSafety));
                    }
                    return SafetyPropagationTransfer.updateRegularStore(Safety.UNKNOWN, input, updates);
                }
            }
        }
        return SafetyPropagationTransfer.unknown(input);
    }

    private static Safety getValueOfSubNode(TransferInput<Safety, AccessPathStore<Safety>> input, Node node) {
        Safety maybeSafety = (Safety)input.getValueOfSubNode(node);
        return Safety.nullToUnknown(maybeSafety);
    }

    private static final class ReadableUpdates
    implements Updates {
        private final Map<AccessPath, Safety> values = new HashMap<AccessPath, Safety>();

        private ReadableUpdates() {
        }

        @Override
        public void set(LocalVariableNode node, Safety value) {
            this.values.put(AccessPath.fromLocalVariable((LocalVariableNode)node), Objects.requireNonNull(value));
        }

        @Override
        public void set(VariableDeclarationNode node, Safety value) {
            this.values.put(AccessPath.fromVariableDecl((VariableDeclarationNode)node), Objects.requireNonNull(value));
        }

        @Override
        public void set(FieldAccessNode node, Safety value) {
            AccessPath path = AccessPath.fromFieldAccess((FieldAccessNode)node);
            if (path != null) {
                this.values.put(path, Objects.requireNonNull(value));
            }
        }

        @Override
        public void set(AccessPath path, Safety value) {
            this.values.put(Objects.requireNonNull(path), Objects.requireNonNull(value));
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }
    }

    static interface Updates {
        public void set(LocalVariableNode var1, Safety var2);

        public void set(VariableDeclarationNode var1, Safety var2);

        public void set(FieldAccessNode var1, Safety var2);

        public void set(AccessPath var1, Safety var2);

        default public void trySet(Node node, Safety value) {
            if (node instanceof LocalVariableNode) {
                this.set((LocalVariableNode)node, value);
            } else if (node instanceof FieldAccessNode) {
                this.set((FieldAccessNode)node, value);
            } else if (node instanceof VariableDeclarationNode) {
                this.set((VariableDeclarationNode)node, value);
            }
        }

        public boolean isEmpty();
    }

    private static final class ResultingStore {
        private final AccessPathStore<Safety> store;
        private final boolean storeChanged;

        ResultingStore(AccessPathStore<Safety> store, boolean storeChanged) {
            this.store = store;
            this.storeChanged = storeChanged;
        }
    }

    public final class ClearVisitorState
    implements Closeable {
        @Override
        public void close() {
            SafetyPropagationTransfer.this.state = null;
            SafetyPropagationTransfer.this.traversed.clear();
        }
    }
}

