/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="@CompileTimeConstant annotations on method parameters must also be applied to the super method. Similarly, if a superclass or superinterface is annotated, implementations must also be annotated.")
@AutoService(value={BugChecker.class})
public final class CompileTimeConstantViolatesLiskovSubstitution
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> INEXPENSIVE_CHECK = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.hasModifier((Modifier)Modifier.STATIC), Matchers.hasModifier((Modifier)Modifier.PRIVATE)});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (INEXPENSIVE_CHECK.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        Set superMethods = ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes());
        if (superMethods.isEmpty()) {
            return Description.NO_MATCH;
        }
        int parameterIndex = -1;
        for (Symbol.VarSymbol parameter : methodSymbol.getParameters()) {
            ++parameterIndex;
            if (ASTHelpers.hasAnnotation((Symbol)parameter, (String)CompileTimeConstant.class.getName(), (VisitorState)state)) {
                if (!this.anySuperMethodsMissingParameterAnnotation(superMethods, parameterIndex, state)) continue;
                state.reportMatch(this.buildDescription(tree.getParameters().get(parameterIndex)).setMessage("@CompileTimeConstant annotations on method parameters must also be applied to the super method otherwise non-constant values will be allowed based on the reference variable type.").build());
                continue;
            }
            if (!this.anySuperMethodsHaveParameterAnnotation(superMethods, parameterIndex, state)) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            VariableTree parameterTree = tree.getParameters().get(parameterIndex);
            fix.prefixWith((Tree)parameterTree, String.format("@%s ", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)CompileTimeConstant.class.getName())));
            state.reportMatch(this.buildDescription(parameterTree).setMessage("When a superclass or superinterface is annotated with @CompileTimeConstant, implementations must also be annotated otherwise non-constant values will be allowed based on the reference variable type.").addFix((Fix)fix.build()).build());
        }
        return Description.NO_MATCH;
    }

    private boolean anySuperMethodsMissingParameterAnnotation(Set<Symbol.MethodSymbol> superMethods, int parameterIndex, VisitorState state) {
        for (Symbol.MethodSymbol superMethod : superMethods) {
            Symbol.VarSymbol parameter = (Symbol.VarSymbol)((List)superMethod.getParameters()).get(parameterIndex);
            if (ASTHelpers.hasAnnotation((Symbol)parameter, (String)CompileTimeConstant.class.getName(), (VisitorState)state)) continue;
            return true;
        }
        return false;
    }

    private boolean anySuperMethodsHaveParameterAnnotation(Set<Symbol.MethodSymbol> superMethods, int parameterIndex, VisitorState state) {
        for (Symbol.MethodSymbol superMethod : superMethods) {
            Symbol.VarSymbol parameter = (Symbol.VarSymbol)((List)superMethod.getParameters()).get(parameterIndex);
            if (!ASTHelpers.hasAnnotation((Symbol)parameter, (String)CompileTimeConstant.class.getName(), (VisitorState)state)) continue;
            return true;
        }
        return false;
    }
}

