/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.palantir.baseline.errorprone.Records;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.palantir.baseline.errorprone.safety.Safety;
import com.palantir.baseline.errorprone.safety.SafetyAnalysis;
import com.palantir.baseline.errorprone.safety.SafetyAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import javax.lang.model.element.Modifier;
import org.checkerframework.errorprone.javacutil.TreePathUtil;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, summary="Safe logging annotations should be propagated to encapsulating elements to allow static analysis tooling to work with as much information as possible. This check can be auto-fixed using `./gradlew classes testClasses -PerrorProneApply=SafeLoggingPropagation`")
@AutoService(value={BugChecker.class})
public final class SafeLoggingPropagation
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final Matcher<Tree> SAFETY_ANNOTATION_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType((String)"com.palantir.logsafe.Safe"), Matchers.isSameType((String)"com.palantir.logsafe.Unsafe"), Matchers.isSameType((String)"com.palantir.logsafe.DoNotLog")});
    private static final Matcher<MethodTree> TO_STRING = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"toString"), Matchers.methodHasNoParameters(), Matchers.not((Matcher)Matchers.isStatic()), Matchers.methodReturns((Matcher)Matchers.isSameType(String.class))});
    private static final Matcher<MethodTree> METHOD_RETURNS_VOID = Matchers.methodReturns((Matcher)Matchers.isVoidType());
    private static final Supplier<Name> TO_STRING_NAME = VisitorState.memoize((Supplier & Serializable)state -> state.getName("toString"));
    private static final Supplier<Name> IMMUTABLES_STYLE = VisitorState.memoize((Supplier & Serializable)state -> state.getName("org.immutables.value.Value.Style"));
    private static final Supplier<Name> JACKSON_ANNOTATION = VisitorState.memoize((Supplier & Serializable)state -> state.getName("com.fasterxml.jackson.annotation.JacksonAnnotation"));

    public Description matchClass(ClassTree classTree, VisitorState state) {
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (classSymbol == null || classSymbol.isAnonymous()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isRecord((Symbol)classSymbol)) {
            return this.matchRecord(classTree, classSymbol, state);
        }
        return this.matchClassOrInterface(classTree, classSymbol, state);
    }

    private static boolean hasJacksonAnnotation(Symbol typeSymbol, VisitorState state) {
        return SafeLoggingPropagation.hasJacksonAnnotation(typeSymbol, state, 1) && !ASTHelpers.hasAnnotation((Symbol)typeSymbol, (String)"com.fasterxml.jackson.annotation.JsonIgnore", (VisitorState)state);
    }

    private static boolean hasJacksonAnnotation(Symbol typeSymbol, VisitorState state, int nestedDepth) {
        if (typeSymbol != null) {
            Name jacksonAnnotationName = (Name)JACKSON_ANNOTATION.get(state);
            for (Attribute.Compound metadata : typeSymbol.getRawAttributes()) {
                if (jacksonAnnotationName.equals(metadata.type.tsym.getQualifiedName())) {
                    return true;
                }
                if (nestedDepth <= 0 || !SafeLoggingPropagation.hasJacksonAnnotation(metadata.type.tsym, state, nestedDepth - 1)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean immutablesDefaultAsDefault(Symbol.TypeSymbol typeSymbol, VisitorState state) {
        return SafeLoggingPropagation.immutablesDefaultAsDefault(typeSymbol, state, 1);
    }

    private static boolean immutablesDefaultAsDefault(Symbol.TypeSymbol typeSymbol, VisitorState state, int nestedDepth) {
        Name styleName = (Name)IMMUTABLES_STYLE.get(state);
        for (Attribute.Compound metadata : typeSymbol.getRawAttributes()) {
            if (styleName.equals(metadata.type.tsym.getQualifiedName())) {
                return SafeLoggingPropagation.immutablesDefaultAsDefault(metadata);
            }
            if (nestedDepth <= 0 || !SafeLoggingPropagation.immutablesDefaultAsDefault(metadata.type.tsym, state, nestedDepth - 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean immutablesDefaultAsDefault(Attribute.Compound styleAnnotation) {
        return MoreAnnotations.getValue((Attribute.Compound)styleAnnotation, (String)"defaultAsDefault").map(attr -> (boolean)((Boolean)attr.getValue())).orElse(false);
    }

    private Description matchRecord(ClassTree classTree, Symbol.ClassSymbol classSymbol, VisitorState state) {
        Safety existingClassSafety = SafetyAnnotations.getSafety(classTree, state);
        Safety safety = SafetyAnnotations.getTypeSafetyFromAncestors(classTree, state);
        for (Symbol.VarSymbol recordComponent : Records.getRecordComponents(classSymbol)) {
            Safety symbolSafety = SafetyAnnotations.getSafety(recordComponent, state);
            Safety typeSafety = SafetyAnnotations.getSafety(recordComponent.type, state);
            Safety typeSymSafety = SafetyAnnotations.getSafety(recordComponent.type.tsym, state);
            Safety recordComponentSafety = Safety.mergeAssumingUnknownIsSame(symbolSafety, typeSafety, typeSymSafety);
            safety = (Safety)safety.leastUpperBound(recordComponentSafety);
        }
        return this.handleSafety(classTree, classTree.getModifiers(), state, existingClassSafety, safety);
    }

    private Description matchClassOrInterface(ClassTree classTree, Symbol.ClassSymbol classSymbol, VisitorState state) {
        if (ASTHelpers.hasAnnotation((Symbol)classSymbol, (String)"org.immutables.value.Value.Immutable", (VisitorState)state)) {
            return this.matchImmutables(classTree, classSymbol, state);
        }
        return this.matchBasedOnToString(classTree, classSymbol, state);
    }

    private static boolean isImmutablesField(Symbol.ClassSymbol enclosingClass, Symbol.MethodSymbol methodSymbol, VisitorState state) {
        return methodSymbol.getModifiers().contains((Object)Modifier.ABSTRACT) || ASTHelpers.hasAnnotation((Symbol)methodSymbol, (String)"org.immutables.value.Value.Default", (VisitorState)state) || ASTHelpers.hasAnnotation((Symbol)methodSymbol, (String)"org.immutables.value.Value.Derived", (VisitorState)state) || ASTHelpers.hasAnnotation((Symbol)methodSymbol, (String)"org.immutables.value.Value.Lazy", (VisitorState)state) || SafeLoggingPropagation.immutablesDefaultAsDefault(enclosingClass, state) || SafeLoggingPropagation.hasJacksonAnnotation(methodSymbol, state);
    }

    private static boolean isToString(Symbol.MethodSymbol methodSymbol, VisitorState state) {
        return !methodSymbol.isConstructor() && !methodSymbol.isStaticOrInstanceInit() && state.getTypes().isSameType(methodSymbol.getReturnType(), state.getSymtab().stringType) && methodSymbol.name.contentEquals("toString") && ((List)methodSymbol.getParameters()).isEmpty();
    }

    private static boolean isGetterMethod(Symbol.ClassSymbol enclosingClass, Symbol.MethodSymbol methodSymbol, VisitorState state) {
        return !methodSymbol.isConstructor() && !methodSymbol.isStaticOrInstanceInit() && !state.getTypes().isSameType(methodSymbol.getReturnType(), state.getSymtab().voidType) && ((List)methodSymbol.getParameters()).isEmpty() && (SafeLoggingPropagation.isImmutablesField(enclosingClass, methodSymbol, state) || SafeLoggingPropagation.isToString(methodSymbol, state));
    }

    private static Safety scanSymbolMethods(Symbol.ClassSymbol begin, VisitorState state, boolean usesJackson) {
        Safety safety = Safety.UNKNOWN;
        for (Symbol enclosed : ASTHelpers.getEnclosedElements((Symbol)begin)) {
            boolean redacted;
            Symbol.MethodSymbol methodSymbol;
            if (!(enclosed instanceof Symbol.MethodSymbol) || !SafeLoggingPropagation.isGetterMethod(begin, methodSymbol = (Symbol.MethodSymbol)enclosed, state) || (redacted = ASTHelpers.hasAnnotation((Symbol)methodSymbol, (String)"org.immutables.value.Value.Redacted", (VisitorState)state)) && !usesJackson && !SafeLoggingPropagation.hasJacksonAnnotation(methodSymbol, state)) continue;
            Safety getterSafety = Safety.mergeAssumingUnknownIsSame(safety, SafetyAnnotations.getSafety(methodSymbol, state));
            getterSafety = Safety.mergeAssumingUnknownIsSame(getterSafety, SafetyAnnotations.getSafety(methodSymbol.getReturnType(), state));
            getterSafety = Safety.mergeAssumingUnknownIsSame(getterSafety, SafetyAnnotations.getSafety(methodSymbol.getReturnType().tsym, state));
            if (redacted && (getterSafety == Safety.UNKNOWN || getterSafety == Safety.SAFE)) {
                getterSafety = Safety.DO_NOT_LOG;
            }
            safety = (Safety)safety.leastUpperBound(getterSafety);
        }
        Type superClassType = begin.getSuperclass();
        if (superClassType != null && superClassType.tsym instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol superClassSym = (Symbol.ClassSymbol)superClassType.tsym;
            Safety superClassMethodSafety = SafeLoggingPropagation.scanSymbolMethods(superClassSym, state, usesJackson);
            safety = Safety.mergeAssumingUnknownIsSame(safety, superClassMethodSafety);
        }
        for (Type superIface : begin.getInterfaces()) {
            if (!(superIface.tsym instanceof Symbol.ClassSymbol)) continue;
            Symbol.ClassSymbol superIfaceClassSymbol = (Symbol.ClassSymbol)superIface.tsym;
            Safety superClassMethodSafety = SafeLoggingPropagation.scanSymbolMethods(superIfaceClassSymbol, state, usesJackson);
            safety = Safety.mergeAssumingUnknownIsSame(safety, superClassMethodSafety);
        }
        return safety;
    }

    private Description matchImmutables(ClassTree classTree, Symbol.ClassSymbol classSymbol, VisitorState state) {
        Safety existingClassSafety = SafetyAnnotations.getAnnotatedSafety(classTree, state);
        Safety safety = SafetyAnnotations.getTypeSafetyFromAncestors(classTree, state);
        boolean isJson = SafeLoggingPropagation.hasJacksonAnnotation(classSymbol, state);
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)classTree);
        Safety scanned = SafeLoggingPropagation.scanSymbolMethods(symbol, state, isJson);
        safety = (Safety)safety.leastUpperBound(scanned);
        return this.handleSafety(classTree, classTree.getModifiers(), state, existingClassSafety, safety);
    }

    private Description matchBasedOnToString(ClassTree classTree, Symbol.ClassSymbol classSymbol, VisitorState state) {
        Symbol.MethodSymbol toStringSymbol = ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)classSymbol, (Name)((Name)TO_STRING_NAME.get(state)), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
        if (toStringSymbol == null) {
            return Description.NO_MATCH;
        }
        Safety existingClassSafety = SafetyAnnotations.getSafety(classTree, state);
        Safety symbolSafety = SafetyAnnotations.getSafety(toStringSymbol, state);
        return this.handleSafety(classTree, classTree.getModifiers(), state, existingClassSafety, symbolSafety);
    }

    private Description handleSafety(Tree tree, ModifiersTree treeModifiers, VisitorState state, Safety existingSafety, Safety computedSafety) {
        if (existingSafety != Safety.UNKNOWN && existingSafety.allowsValueWith(computedSafety)) {
            return Description.NO_MATCH;
        }
        switch (computedSafety) {
            case UNKNOWN: {
                return Description.NO_MATCH;
            }
            case SAFE: {
                return Description.NO_MATCH;
            }
            case DO_NOT_LOG: {
                return this.annotate(tree, treeModifiers, state, "com.palantir.logsafe.DoNotLog");
            }
            case UNSAFE: {
                return this.annotate(tree, treeModifiers, state, "com.palantir.logsafe.Unsafe");
            }
        }
        return Description.NO_MATCH;
    }

    private Description annotate(Tree tree, ModifiersTree treeModifiers, VisitorState state, String annotationName) {
        if (TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String qualifiedAnnotation = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)annotationName);
        for (AnnotationTree annotationTree : treeModifiers.getAnnotations()) {
            Tree annotationType = annotationTree.getAnnotationType();
            if (!SAFETY_ANNOTATION_MATCHER.matches(annotationType, state)) continue;
            fix.replace((Tree)annotationTree, "");
        }
        fix.prefixWith(tree, String.format("@%s ", qualifiedAnnotation));
        return this.buildDescription(tree).addFix((Fix)fix.build()).build();
    }

    public Description matchMethod(MethodTree method, VisitorState state) {
        if (METHOD_RETURNS_VOID.matches((Tree)method, state) || method.getReturnType() == null) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)method);
        if (methodSymbol.owner.isAnonymous()) {
            return Description.NO_MATCH;
        }
        Safety methodDeclaredSafety = Safety.mergeAssumingUnknownIsSame(SafetyAnnotations.getSafety(methodSymbol, state), SafetyAnnotations.getSafety(method.getReturnType(), state));
        if (methodDeclaredSafety != Safety.DO_NOT_LOG && methodDeclaredSafety != Safety.UNSAFE && ASTHelpers.hasAnnotation((Symbol)methodSymbol, (String)"org.immutables.value.Value.Redacted", (VisitorState)state)) {
            return this.handleSafety(method, method.getModifiers(), state, methodDeclaredSafety, Safety.DO_NOT_LOG);
        }
        if (methodDeclaredSafety != Safety.UNKNOWN) {
            return Description.NO_MATCH;
        }
        if ((methodSymbol.flags() & 0x400L) != 0L) {
            return Description.NO_MATCH;
        }
        if (TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        Safety combinedReturnSafety = method.accept(new ReturnStatementSafetyScanner(method), state);
        if (combinedReturnSafety == null) {
            return Description.NO_MATCH;
        }
        return this.handleSafety(method, method.getModifiers(), state, methodDeclaredSafety, combinedReturnSafety);
    }

    private static final class ReturnStatementSafetyScanner
    extends TreeScanner<Safety, VisitorState> {
        private final MethodTree target;

        ReturnStatementSafetyScanner(MethodTree target) {
            this.target = target;
        }

        @Override
        public Safety visitReturn(ReturnTree node, VisitorState visitorState) {
            ExpressionTree expression = node.getExpression();
            if (expression == null) {
                return null;
            }
            TreePath path = TreePath.getPath(visitorState.getPath().getCompilationUnit(), (Tree)expression);
            if (this.target.equals(TreePathUtil.enclosingMethodOrLambda((TreePath)path))) {
                return SafetyAnalysis.of(visitorState.withPath(path));
            }
            return Safety.UNKNOWN;
        }

        @Override
        public Safety visitClass(ClassTree _node, VisitorState _obj) {
            return null;
        }

        @Override
        public Safety visitNewClass(NewClassTree node, VisitorState _state) {
            return null;
        }

        @Override
        public Safety visitLambdaExpression(LambdaExpressionTree node, VisitorState _state) {
            return null;
        }

        @Override
        public Safety reduce(Safety lhs, Safety rhs) {
            if (lhs == null) {
                return rhs;
            }
            if (rhs == null) {
                return lhs;
            }
            return (Safety)lhs.leastUpperBound(rhs);
        }
    }
}

