/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Allow only compile-time constant slf4j log message strings.")
@AutoService(value={BugChecker.class})
public final class Slf4jConstantLogMessage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> LOG_METHOD = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").withNameMatching(Pattern.compile("trace|debug|info|warn|error"));
    private static final Matcher<ExpressionTree> MARKER = MoreMatchers.isSubtypeOf("org.slf4j.Marker");
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree messageArg;
        if (!LOG_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        ExpressionTree expressionTree = messageArg = MARKER.matches((Tree)tree.getArguments().get(0), state) ? args.get(1) : args.get(0);
        if (this.compileTimeConstExpressionMatcher.matches((Tree)messageArg, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("slf4j log statement uses a non-constant expression").build();
    }
}

