/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.Comparator;
import java.util.stream.Stream;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, summary="Using Stream::min is more efficient than finding the first element of the sorted stream. Stream::min performs a linear scan through the stream to find the smallest element.")
@AutoService(value={BugChecker.class})
public final class SortedStreamFirstElement
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> STREAM_FIND_FIRST_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(Stream.class.getName()).named("findFirst").withNoParameters();
    private static final Matcher<MethodInvocationTree> RECEIVER_OF_STREAM_SORTED_NO_PARAMS_MATCHER = Matchers.receiverOfInvocation((Matcher)MethodMatchers.instanceMethod().onDescendantOf(Stream.class.getName()).named("sorted").withNoParameters());
    private static final Matcher<MethodInvocationTree> RECEIVER_OF_STREAM_SORTED_WITH_COMPARATOR_MATCHER = Matchers.receiverOfInvocation((Matcher)MethodMatchers.instanceMethod().onDescendantOf(Stream.class.getName()).named("sorted").withParameters(Comparator.class.getName(), new String[0]));
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{STREAM_FIND_FIRST_MATCHER, Matchers.anyOf((Matcher[])new Matcher[]{RECEIVER_OF_STREAM_SORTED_NO_PARAMS_MATCHER, RECEIVER_OF_STREAM_SORTED_WITH_COMPARATOR_MATCHER})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree sorted = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (sorted == null) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree sortedTree = (MethodInvocationTree)sorted;
        ExpressionTree stream = ASTHelpers.getReceiver((ExpressionTree)sorted);
        if (stream == null) {
            return Description.NO_MATCH;
        }
        if (RECEIVER_OF_STREAM_SORTED_NO_PARAMS_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(SortedStreamFirstElement.getStartPosition(tree), state.getEndPosition((Tree)tree), state.getSourceForNode((Tree)stream) + ".min(Comparator.naturalOrder())").addImport(Comparator.class.getCanonicalName()).build());
        }
        if (RECEIVER_OF_STREAM_SORTED_WITH_COMPARATOR_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(SortedStreamFirstElement.getStartPosition(tree), state.getEndPosition((Tree)tree), state.getSourceForNode((Tree)stream) + ".min(" + state.getSourceForNode((Tree)sortedTree.getArguments().get(0)) + ")").build());
        }
        return Description.NO_MATCH;
    }

    private static int getStartPosition(Tree tree) {
        return ((JCTree.JCMethodInvocation)tree).getStartPosition();
    }
}

