/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Types should not be qualified if they are also imported")
@AutoService(value={BugChecker.class})
public final class UnnecessarilyQualified
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        String nameString = state.getSourceForNode((Tree)tree);
        if (nameString == null) {
            return Description.NO_MATCH;
        }
        CompilationUnitTree compilationUnitTree = (CompilationUnitTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), CompilationUnitTree.class);
        if (compilationUnitTree == null || ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ImportTree.class) != null) {
            return Description.NO_MATCH;
        }
        for (ImportTree importTree : compilationUnitTree.getImports()) {
            if (importTree.isStatic() || !nameString.equals(state.getSourceForNode(importTree.getQualifiedIdentifier()))) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String treeSource = state.getSourceForNode((Tree)tree);
            String updated = treeSource.replace(nameString, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)nameString));
            return this.buildDescription(tree).addFix((Fix)fix.replace((Tree)tree, updated).build()).build();
        }
        return Description.NO_MATCH;
    }
}

