/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone.safety;

import com.google.errorprone.VisitorState;
import com.google.errorprone.dataflow.DataFlow;
import com.palantir.baseline.errorprone.safety.Safety;
import com.palantir.baseline.errorprone.safety.SafetyPropagationTransfer;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Context;
import org.checkerframework.errorprone.dataflow.analysis.ForwardTransferFunction;

public final class SafetyAnalysis {
    private static final Context.Key<SafetyPropagationTransfer> SAFETY_PROPAGATION = new Context.Key();

    public static Safety of(VisitorState state) {
        SafetyPropagationTransfer propagation = SafetyAnalysis.instance(state.context);
        try (SafetyPropagationTransfer.ClearVisitorState ignored = propagation.setVisitorState(state);){
            Safety safety = Safety.nullToUnknown((Safety)DataFlow.expressionDataflow((TreePath)state.getPath(), (Context)state.context, (ForwardTransferFunction)propagation));
            return safety;
        }
    }

    private static SafetyPropagationTransfer instance(Context context) {
        SafetyPropagationTransfer instance = context.get(SAFETY_PROPAGATION);
        if (instance == null) {
            instance = new SafetyPropagationTransfer();
            context.put(SAFETY_PROPAGATION, instance);
        }
        return instance;
    }

    private SafetyAnalysis() {
    }
}

