/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone.safety;

import com.google.common.collect.Multimap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.safety.Safety;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public final class SafetyAnnotations {
    public static final String SAFE = "com.palantir.logsafe.Safe";
    public static final String UNSAFE = "com.palantir.logsafe.Unsafe";
    public static final String DO_NOT_LOG = "com.palantir.logsafe.DoNotLog";
    private static final Supplier<Name> safeName = VisitorState.memoize((Supplier & Serializable)state -> state.getName(SAFE));
    private static final Supplier<Name> unsafeName = VisitorState.memoize((Supplier & Serializable)state -> state.getName(UNSAFE));
    private static final Supplier<Name> doNotLogName = VisitorState.memoize((Supplier & Serializable)state -> state.getName(DO_NOT_LOG));
    private static final Supplier<Type> throwableSupplier = Suppliers.typeFromClass(Throwable.class);
    private static final TypeArgumentHandlers SAFETY_IS_COMBINATION_OF_TYPE_ARGUMENTS = new TypeArgumentHandlers(new TypeArgumentHandler(Iterable.class), new TypeArgumentHandler(Iterator.class), new TypeArgumentHandler(Map.class), new TypeArgumentHandler(Map.Entry.class), new TypeArgumentHandler(Multimap.class), new TypeArgumentHandler(Stream.class), new TypeArgumentHandler(Optional.class));

    public static Safety getAnnotatedSafety(Tree tree, VisitorState state) {
        Safety safety = Safety.UNKNOWN;
        for (AnnotationTree annotationTree : ASTHelpers.getAnnotations((Tree)tree)) {
            Tree annotationType = annotationTree.getAnnotationType();
            Type type = ASTHelpers.getType((Tree)annotationType);
            if (type == null) continue;
            if (type.tsym.getQualifiedName().equals(doNotLogName.get(state))) {
                safety = Safety.mergeAssumingUnknownIsSame(safety, Safety.DO_NOT_LOG);
                continue;
            }
            if (type.tsym.getQualifiedName().equals(unsafeName.get(state))) {
                safety = Safety.mergeAssumingUnknownIsSame(safety, Safety.UNSAFE);
                continue;
            }
            if (!type.tsym.getQualifiedName().equals(safeName.get(state))) continue;
            safety = Safety.mergeAssumingUnknownIsSame(safety, Safety.SAFE);
        }
        return safety;
    }

    public static Safety getSafety(Tree tree, VisitorState state) {
        Symbol treeSymbol = ASTHelpers.getSymbol((Tree)tree);
        Safety symbolSafety = SafetyAnnotations.getSafety(treeSymbol, state);
        Type treeType = tree instanceof ExpressionTree ? ASTHelpers.getResultType((ExpressionTree)((ExpressionTree)tree)) : ASTHelpers.getType((Tree)tree);
        Safety treeTypeSafety = treeType == null ? Safety.UNKNOWN : Safety.mergeAssumingUnknownIsSame(SafetyAnnotations.getSafety(treeType, state), SafetyAnnotations.getSafety(treeType.tsym, state));
        Type symbolType = treeSymbol == null ? null : treeSymbol.type;
        Safety symbolTypeSafety = symbolType == null || treeType != null && state.getTypes().isSameType(treeType, symbolType) ? Safety.UNKNOWN : Safety.mergeAssumingUnknownIsSame(SafetyAnnotations.getSafety(symbolType, state), SafetyAnnotations.getSafety(symbolType.tsym, state));
        return Safety.mergeAssumingUnknownIsSame(symbolSafety, treeTypeSafety, symbolTypeSafety);
    }

    public static Safety getSafety(@Nullable Symbol symbol, VisitorState state) {
        if (symbol != null) {
            Safety direct = SafetyAnnotations.getDirectSafety(symbol, state);
            if (direct != Safety.UNKNOWN) {
                return direct;
            }
            if (symbol instanceof Symbol.MethodSymbol) {
                return SafetyAnnotations.getSuperMethodSafety((Symbol.MethodSymbol)symbol, state);
            }
            if (symbol instanceof Symbol.TypeVariableSymbol) {
                return SafetyAnnotations.getTypeVariableSymbolSafety((Symbol.TypeVariableSymbol)symbol);
            }
            if (symbol instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                return SafetyAnnotations.getSuperMethodParameterSafety(varSymbol, state);
            }
            if (symbol instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                Safety safety = SafetyAnnotations.getSafety(classSymbol.getSuperclass().tsym, state);
                for (Type type : classSymbol.getInterfaces()) {
                    safety = Safety.mergeAssumingUnknownIsSame(safety, SafetyAnnotations.getSafety(type.tsym, state));
                }
                return safety;
            }
        }
        return Safety.UNKNOWN;
    }

    public static Safety getSafety(@Nullable Type type, VisitorState state) {
        if (type != null) {
            return SafetyAnnotations.getSafetyInternal(type, state, null);
        }
        return Safety.UNKNOWN;
    }

    public static Safety getTypeSafetyFromAncestors(ClassTree classTree, VisitorState state) {
        Safety safety = SafetyAnnotations.getSafety(classTree.getExtendsClause(), state);
        for (Tree tree : classTree.getImplementsClause()) {
            safety = Safety.mergeAssumingUnknownIsSame(safety, SafetyAnnotations.getSafety(tree, state));
        }
        return safety;
    }

    public static Safety getDirectSafety(@Nullable Symbol symbol, VisitorState state) {
        if (symbol != null) {
            if (SafetyAnnotations.containsAttributeNamed(symbol, (Name)doNotLogName.get(state))) {
                return Safety.DO_NOT_LOG;
            }
            if (SafetyAnnotations.containsAttributeNamed(symbol, (Name)unsafeName.get(state))) {
                return Safety.UNSAFE;
            }
            if (SafetyAnnotations.containsAttributeNamed(symbol, (Name)safeName.get(state))) {
                return Safety.SAFE;
            }
        }
        return Safety.UNKNOWN;
    }

    private static boolean containsAttributeNamed(Symbol symbol, Name annotationName) {
        for (Attribute.Compound compound : symbol.getRawAttributes()) {
            if (!compound.type.tsym.getQualifiedName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    private static Safety getTypeVariableSymbolSafety(Symbol.TypeVariableSymbol typeVariableSymbol) {
        for (int i = 0; i < typeVariableSymbol.owner.getTypeParameters().size(); ++i) {
            SymbolMetadata metadata = typeVariableSymbol.owner.getMetadata();
            if (metadata == null) continue;
            for (Attribute.TypeCompound attr : metadata.getTypeAttributes()) {
                Safety maybeSafety;
                if (attr.position.type != TargetType.CLASS_TYPE_PARAMETER && attr.position.type != TargetType.METHOD_TYPE_PARAMETER || attr.position.parameter_index != i || (maybeSafety = SafetyAnnotations.getSafetyAnnotationValue(attr)) == null) continue;
                return maybeSafety;
            }
        }
        return Safety.UNKNOWN;
    }

    private static Safety getSafetyInternal(Type type, VisitorState state, Set<String> dejaVu) {
        java.util.List typeAnnotations = type.getAnnotationMirrors();
        for (Attribute.TypeCompound annotation : typeAnnotations) {
            Safety maybeSafety = SafetyAnnotations.getSafetyAnnotationValue(annotation);
            if (maybeSafety == null) continue;
            return maybeSafety;
        }
        Safety typeArgumentCombination = SAFETY_IS_COMBINATION_OF_TYPE_ARGUMENTS.getSafety(type, state, dejaVu);
        if (type instanceof Type.ArrayType) {
            typeArgumentCombination = Safety.mergeAssumingUnknownIsSame(typeArgumentCombination, SafetyAnnotations.getSafety(((Type.ArrayType)type).elemtype.tsym, state));
        }
        return ASTHelpers.isSubtype((Type)type, (Type)((Type)throwableSupplier.get(state)), (VisitorState)state) ? (Safety)Safety.UNSAFE.leastUpperBound(typeArgumentCombination) : typeArgumentCombination;
    }

    @Nullable
    private static Safety getSafetyAnnotationValue(Attribute.TypeCompound annotation) {
        TypeElement annotationElement = (TypeElement)annotation.getAnnotationType().asElement();
        Name name = annotationElement.getQualifiedName();
        if (name.contentEquals(DO_NOT_LOG)) {
            return Safety.DO_NOT_LOG;
        }
        if (name.contentEquals(UNSAFE)) {
            return Safety.UNSAFE;
        }
        if (name.contentEquals(SAFE)) {
            return Safety.SAFE;
        }
        return null;
    }

    private static Safety getSuperMethodSafety(Symbol.MethodSymbol method, VisitorState state) {
        Safety safety = Safety.UNKNOWN;
        if (!method.isStaticOrInstanceInit()) {
            for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes())) {
                safety = Safety.mergeAssumingUnknownIsSame(safety, SafetyAnnotations.getSafety(superMethod, state));
            }
        }
        return safety;
    }

    private static Safety getSuperMethodParameterSafety(Symbol.VarSymbol varSymbol, VisitorState state) {
        Symbol.MethodSymbol method;
        Safety safety = Safety.UNKNOWN;
        if (varSymbol.owner instanceof Symbol.MethodSymbol && !(method = (Symbol.MethodSymbol)varSymbol.owner).isStaticOrInstanceInit()) {
            java.util.List methodParameters = method.getParameters();
            for (int i = 0; i < ((List)methodParameters).size(); ++i) {
                Symbol.VarSymbol current = (Symbol.VarSymbol)((List)methodParameters).get(i);
                if (!Objects.equals(current, varSymbol)) continue;
                for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes())) {
                    safety = Safety.mergeAssumingUnknownIsSame(safety, SafetyAnnotations.getSafety((Symbol)((List)superMethod.getParameters()).get(i), state));
                }
                return safety;
            }
        }
        return safety;
    }

    private SafetyAnnotations() {
    }

    private static final class TypeArgumentHandler {
        private final Supplier<Type> typeSupplier;

        TypeArgumentHandler(Class<?> clazz) {
            if (clazz.getTypeParameters().length == 0) {
                throw new IllegalStateException("Class " + clazz + " has no type parameters");
            }
            this.typeSupplier = Suppliers.typeFromClass(clazz);
        }

        private static Type unwrapWildcard(Type type) {
            Type.WildcardType wildcard;
            Type ext;
            if (type instanceof Type.WildcardType && (ext = (wildcard = (Type.WildcardType)type).getExtendsBound()) != null) {
                return ext;
            }
            return type;
        }

        @Nullable
        Safety getSafety(Type type, VisitorState state, @Nullable Set<String> dejaVu) {
            Type baseType = (Type)this.typeSupplier.get(state);
            if (ASTHelpers.isSubtype((Type)type, (Type)baseType, (VisitorState)state)) {
                String typeString;
                HashSet<String> deJaVuToPass = dejaVu == null ? new HashSet<String>() : dejaVu;
                if (!deJaVuToPass.add(typeString = type.toString())) {
                    return Safety.UNKNOWN;
                }
                Type asSubtype = state.getTypes().asSuper(TypeArgumentHandler.unwrapWildcard(type), baseType.tsym);
                if (asSubtype == null) {
                    return null;
                }
                Safety safety = Safety.SAFE;
                List<Type> typeArguments = asSubtype.getTypeArguments();
                if (typeArguments.isEmpty()) {
                    return null;
                }
                for (Type typeArgument : typeArguments) {
                    Safety safetyBasedOnType = SafetyAnnotations.getSafetyInternal(typeArgument, state, deJaVuToPass);
                    Safety safetyBasedOnSymbol = SafetyAnnotations.getSafety(typeArgument.tsym, state);
                    Safety typeArgumentSafety = Safety.mergeAssumingUnknownIsSame(safetyBasedOnType, safetyBasedOnSymbol);
                    safety = (Safety)safety.leastUpperBound(typeArgumentSafety);
                }
                deJaVuToPass.remove(typeString);
                return safety;
            }
            return null;
        }
    }

    private static final class TypeArgumentHandlers {
        private final TypeArgumentHandler[] handlers;

        TypeArgumentHandlers(TypeArgumentHandler ... handlers) {
            this.handlers = handlers;
        }

        Safety getSafety(Type type, VisitorState state, @Nullable Set<String> dejaVu) {
            for (TypeArgumentHandler handler : this.handlers) {
                Safety result = handler.getSafety(type, state, dejaVu);
                if (result == null) continue;
                return result;
            }
            return Safety.UNKNOWN;
        }
    }
}

