/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.palantir.baseline.plugins.BaselineCheckstyle;
import com.palantir.baseline.plugins.BaselineCircleCi;
import com.palantir.baseline.plugins.BaselineClassUniquenessPlugin;
import com.palantir.baseline.plugins.BaselineConfig;
import com.palantir.baseline.plugins.BaselineEclipse;
import com.palantir.baseline.plugins.BaselineEncoding;
import com.palantir.baseline.plugins.BaselineErrorProne;
import com.palantir.baseline.plugins.BaselineExactDependencies;
import com.palantir.baseline.plugins.BaselineFormat;
import com.palantir.baseline.plugins.BaselineIdea;
import com.palantir.baseline.plugins.BaselineImmutables;
import com.palantir.baseline.plugins.BaselineJavaCompilerDiagnostics;
import com.palantir.baseline.plugins.BaselineJavaParameters;
import com.palantir.baseline.plugins.BaselineModuleJvmArgs;
import com.palantir.baseline.plugins.BaselineReleaseCompatibility;
import com.palantir.baseline.plugins.BaselineReproducibility;
import com.palantir.baseline.plugins.BaselineScala;
import com.palantir.baseline.plugins.BaselineTestHeap;
import com.palantir.baseline.plugins.BaselineTesting;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;

public final class Baseline
implements Plugin<Project> {
    public static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.version((String)"6.7");

    public void apply(Project project) {
        if (GradleVersion.current().compareTo(MIN_GRADLE_VERSION) < 0) {
            throw new GradleException(String.format("The minimum supported Gradle version is version %s but got version %s", MIN_GRADLE_VERSION, GradleVersion.current()));
        }
        Project rootProject = project.getRootProject();
        if (!project.equals(rootProject)) {
            project.getLogger().warn("com.palantir.baseline should be applied to the root project only, not '{}'", (Object)project.getName());
        }
        rootProject.getPluginManager().apply(BaselineConfig.class);
        rootProject.getPluginManager().apply(BaselineCircleCi.class);
        rootProject.allprojects(proj -> {
            proj.getPluginManager().apply(BaselineCheckstyle.class);
            proj.getPluginManager().apply(BaselineScala.class);
            proj.getPluginManager().apply(BaselineEclipse.class);
            proj.getPluginManager().apply(BaselineIdea.class);
            proj.getPluginManager().apply(BaselineErrorProne.class);
            proj.getPluginManager().apply(BaselineFormat.class);
            proj.getPluginManager().apply(BaselineEncoding.class);
            proj.getPluginManager().apply(BaselineReproducibility.class);
            proj.getPluginManager().apply(BaselineClassUniquenessPlugin.class);
            proj.getPluginManager().apply(BaselineExactDependencies.class);
            proj.getPluginManager().apply(BaselineReleaseCompatibility.class);
            proj.getPluginManager().apply(BaselineTesting.class);
            proj.getPluginManager().apply(BaselineTestHeap.class);
            proj.getPluginManager().apply(BaselineJavaCompilerDiagnostics.class);
            proj.getPluginManager().apply(BaselineJavaParameters.class);
            proj.getPluginManager().apply(BaselineImmutables.class);
            proj.getPluginManager().apply(BaselineModuleJvmArgs.class);
        });
    }
}

