/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.palantir.baseline.extensions.BaselineErrorProneExtension;
import com.palantir.baseline.extensions.BaselineJavaVersionExtension;
import com.palantir.baseline.tasks.CompileRefasterTask;
import java.io.File;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ltgt.gradle.errorprone.CheckSeverity;
import net.ltgt.gradle.errorprone.ErrorProneOptions;
import net.ltgt.gradle.errorprone.ErrorPronePlugin;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.process.CommandLineArgumentProvider;

public final class BaselineErrorProne
implements Plugin<Project> {
    private static final Logger log = Logging.getLogger(BaselineErrorProne.class);
    public static final String EXTENSION_NAME = "baselineErrorProne";
    private static final String ERROR_PRONE_JAVAC_VERSION = "9+181-r4173-1";
    private static final String PROP_ERROR_PRONE_APPLY = "errorProneApply";
    private static final String PROP_REFASTER_APPLY = "refasterApply";
    private static final String DISABLE_PROPERTY = "com.palantir.baseline-error-prone.disable";

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", unused -> BaselineErrorProne.applyToJavaProject(project));
    }

    private static void applyToJavaProject(Project project) {
        BaselineErrorProneExtension errorProneExtension = (BaselineErrorProneExtension)project.getExtensions().create(EXTENSION_NAME, BaselineErrorProneExtension.class, new Object[]{project});
        project.getPluginManager().apply(ErrorPronePlugin.class);
        String version = Optional.ofNullable(BaselineErrorProne.class.getPackage().getImplementationVersion()).orElseGet(() -> {
            log.warn("Baseline is using 'latest.release' - beware this compromises build reproducibility");
            return "latest.release";
        });
        Configuration refasterConfiguration = (Configuration)project.getConfigurations().create("refaster", conf -> conf.defaultDependencies(deps -> deps.add((Object)project.getDependencies().create((Object)("com.palantir.baseline:baseline-refaster-rules:" + version + ":sources")))));
        Configuration refasterCompilerConfiguration = (Configuration)project.getConfigurations().create("refasterCompiler", configuration -> configuration.extendsFrom(new Configuration[]{refasterConfiguration}));
        project.getDependencies().add("errorprone", (Object)("com.palantir.baseline:baseline-error-prone:" + version));
        project.getDependencies().add("refasterCompiler", (Object)("com.palantir.baseline:baseline-refaster-javac-plugin:" + version));
        Provider refasterRulesFile = project.getLayout().getBuildDirectory().file("refaster/rules.refaster").map(RegularFile::getAsFile);
        CompileRefasterTask compileRefaster = (CompileRefasterTask)project.getTasks().create("compileRefaster", CompileRefasterTask.class, task -> {
            task.setSource(refasterConfiguration);
            task.getRefasterSources().set((Object)refasterConfiguration);
            task.setClasspath((FileCollection)refasterCompilerConfiguration);
            task.getRefasterRulesFile().set(refasterRulesFile);
        });
        if (!JavaVersion.current().isJava9Compatible()) {
            project.getDependencies().add("errorproneJavac", (Object)"com.google.errorprone:javac:9+181-r4173-1");
            project.getConfigurations().named("errorproneJavac").configure(conf -> {
                List bootstrapClasspath = Splitter.on((String)File.pathSeparator).splitToList((CharSequence)System.getProperty("sun.boot.class.path")).stream().map(File::new).collect(Collectors.toList());
                FileCollection errorProneFiles = conf.plus((FileCollection)project.files(new Object[]{bootstrapClasspath}));
                project.getTasks().withType(Test.class).configureEach(test -> test.setBootstrapClasspath(errorProneFiles));
                project.getTasks().withType(Javadoc.class).configureEach(javadoc -> javadoc.getOptions().setBootClasspath((List)new LazyConfigurationList(errorProneFiles)));
            });
        }
        project.getPluginManager().withPlugin("com.palantir.baseline-java-version", unused -> {
            BaselineJavaVersionExtension versionExtension = (BaselineJavaVersionExtension)project.getExtensions().getByType(BaselineJavaVersionExtension.class);
            project.getDependencies().addProvider("errorproneJavac", versionExtension.target().map(target -> target.asInt() == 8 ? "com.google.errorprone:javac:9+181-r4173-1" : null));
        });
        project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> ((ExtensionAware)javaCompile.getOptions()).getExtensions().configure(ErrorProneOptions.class, errorProneOptions -> BaselineErrorProne.configureErrorProneOptions(project, (Provider<File>)refasterRulesFile, compileRefaster, errorProneExtension, javaCompile, errorProneOptions)));
        project.afterEvaluate(unused -> project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> {
            if (javaCompile.equals((Object)compileRefaster)) {
                return;
            }
            if (BaselineErrorProne.isRefactoring(project)) {
                javaCompile.getOptions().setWarnings(false);
                javaCompile.getOptions().setDeprecation(false);
                javaCompile.getOptions().setCompilerArgs(javaCompile.getOptions().getCompilerArgs().stream().filter(arg -> !arg.equals("-Werror")).filter(arg -> !arg.equals("-deprecation")).filter(arg -> !arg.equals("-Xlint:deprecation")).collect(Collectors.toList()));
            }
        }));
        project.getPluginManager().withPlugin("java-gradle-plugin", appliedPlugin -> project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> ((ExtensionAware)javaCompile.getOptions()).getExtensions().configure(ErrorProneOptions.class, errorProneOptions -> {
            errorProneOptions.check("Slf4jLogsafeArgs", CheckSeverity.OFF);
            errorProneOptions.check("PreferSafeLoggableExceptions", CheckSeverity.OFF);
            errorProneOptions.check("PreferSafeLogger", CheckSeverity.OFF);
            errorProneOptions.check("PreferSafeLoggingPreconditions", CheckSeverity.OFF);
            errorProneOptions.check("PreconditionsConstantMessage", CheckSeverity.OFF);
        })));
    }

    private static void configureErrorProneOptions(final Project project, final Provider<File> refasterRulesFile, CompileRefasterTask compileRefaster, final BaselineErrorProneExtension errorProneExtension, final JavaCompile javaCompile, final ErrorProneOptions errorProneOptions) {
        if (project.hasProperty(DISABLE_PROPERTY)) {
            log.info("Disabling baseline-error-prone for {} due to {}", (Object)project, (Object)DISABLE_PROPERTY);
            errorProneOptions.getEnabled().set((Object)false);
        } else {
            errorProneOptions.getEnabled().set((Object)true);
        }
        errorProneOptions.getDisableWarningsInGeneratedCode().set((Object)true);
        errorProneOptions.getExcludedPaths().set((Object)BaselineErrorProne.excludedPathsRegex());
        errorProneOptions.disable(new String[]{"AutoCloseableMustBeClosed", "CatchSpecificity", "InlineMeSuggester", "PreferImmutableStreamExCollections", "UnusedVariable"});
        errorProneOptions.error(new String[]{"EqualsHashCode", "EqualsIncompatibleType", "StreamResourceLeak", "InputStreamSlowMultibyteRead", "JavaDurationGetSecondsGetNano", "URLEqualsHashCode", "BoxedPrimitiveEquality", "ReferenceEquality"});
        if (((Boolean)errorProneOptions.getCompilingTestOnlyCode().get()).booleanValue()) {
            errorProneOptions.disable(new String[]{"UnnecessaryLambda"});
        }
        if (javaCompile.equals((Object)compileRefaster)) {
            return;
        }
        if (BaselineErrorProne.isRefactoring(project)) {
            javaCompile.getOutputs().cacheIf(t -> false);
            if (BaselineErrorProne.isRefasterRefactoring(project)) {
                javaCompile.dependsOn(new Object[]{compileRefaster});
                errorProneOptions.getErrorproneArgumentProviders().add(new CommandLineArgumentProvider(){

                    public Iterable<String> asArguments() {
                        String file = ((File)refasterRulesFile.get()).getAbsolutePath();
                        return new File(file).exists() ? ImmutableList.of((Object)("-XepPatchChecks:refaster:" + file), (Object)"-XepPatchLocation:IN_PLACE") : Collections.emptyList();
                    }
                });
            }
            if (BaselineErrorProne.isErrorProneRefactoring(project)) {
                final Optional maybeSourceSet = (Optional)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().matching(ss -> javaCompile.getName().equals(ss.getCompileJavaTaskName())).stream().collect(MoreCollectors.toOptional());
                errorProneOptions.getErrorproneArgumentProviders().add(new CommandLineArgumentProvider(){

                    public Iterable<String> asArguments() {
                        Stream errorProneChecks = BaselineErrorProne.getSpecificErrorProneChecks(project).orElseGet(() -> BaselineErrorProne.getNotDisabledErrorproneChecks(project, errorProneExtension, javaCompile, maybeSourceSet, errorProneOptions));
                        return ImmutableList.of((Object)("-XepPatchChecks:" + Joiner.on((char)',').join(errorProneChecks.iterator())), (Object)"-XepPatchLocation:IN_PLACE");
                    }
                });
            }
        }
    }

    static String excludedPathsRegex() {
        String separator = File.separator.contains("\\") ? Pattern.quote("\\") : File.separator;
        return String.format(".*%s(build|generated_.*[sS]rc|src%sgenerated.*)%s.*", separator, separator, separator);
    }

    private static Optional<Stream<String>> getSpecificErrorProneChecks(Project project) {
        return Optional.ofNullable(project.findProperty(PROP_ERROR_PRONE_APPLY)).map(Objects::toString).flatMap(value -> Optional.ofNullable(Strings.emptyToNull((String)value))).map(value -> Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)value)).flatMap(list -> list.isEmpty() ? Optional.empty() : Optional.of(list.stream()));
    }

    private static Stream<String> getNotDisabledErrorproneChecks(Project project, BaselineErrorProneExtension errorProneExtension, JavaCompile javaCompile, Optional<SourceSet> maybeSourceSet, ErrorProneOptions errorProneOptions) {
        Predicate<String> filterOutPreconditions = maybeSourceSet.map(ss -> {
            Configuration configuration = (Configuration)project.getConfigurations().findByName(ss.getCompileClasspathConfigurationName());
            if (configuration == null) {
                return null;
            }
            return BaselineErrorProne.filterOutPreconditions(configuration).and(BaselineErrorProne.filterOutSafeLogger(configuration));
        }).orElse(check -> true);
        return ((List)errorProneExtension.getPatchChecks().get()).stream().filter(check -> {
            if (BaselineErrorProne.checkExplicitlyDisabled(errorProneOptions, check)) {
                log.info("Task {}: not applying errorprone check {} because it has severity OFF in errorProneOptions", (Object)javaCompile.getPath(), check);
                return false;
            }
            return filterOutPreconditions.test((String)check);
        });
    }

    private static boolean hasDependenciesMatching(Configuration configuration, Spec<ModuleComponentIdentifier> spec) {
        return !Iterables.isEmpty((Iterable)configuration.getIncoming().artifactView(viewConfiguration -> viewConfiguration.componentFilter(ci -> ci instanceof ModuleComponentIdentifier && spec.isSatisfiedBy((Object)((ModuleComponentIdentifier)ci)))).getArtifacts());
    }

    public static Predicate<String> filterOutPreconditions(Configuration compileClasspath) {
        return BaselineErrorProne.filterOutBasedOnDependency(compileClasspath, "com.palantir.safe-logging", "preconditions", "PreferSafeLoggingPreconditions", "PreferSafeLoggableExceptions");
    }

    private static Predicate<String> filterOutSafeLogger(Configuration compileClasspath) {
        return BaselineErrorProne.filterOutBasedOnDependency(compileClasspath, "com.palantir.safe-logging", "logger", "PreferSafeLogger");
    }

    private static Predicate<String> filterOutBasedOnDependency(Configuration compileClasspath, String dependencyGroup, String dependencyModule, String ... checkNames) {
        boolean hasDependency = BaselineErrorProne.hasDependenciesMatching(compileClasspath, (Spec<ModuleComponentIdentifier>)((Spec)mci -> Objects.equals(mci.getGroup(), dependencyGroup) && Objects.equals(mci.getModule(), dependencyModule)));
        return check -> {
            if (!hasDependency) {
                for (String checkName : checkNames) {
                    if (!Objects.equals(checkName, check)) continue;
                    log.info("Disabling check {} as '{}:{}' missing from {}", new Object[]{checkName, dependencyGroup, dependencyModule, compileClasspath});
                    return false;
                }
            }
            return true;
        };
    }

    private static boolean isRefactoring(Project project) {
        return BaselineErrorProne.isRefasterRefactoring(project) || BaselineErrorProne.isErrorProneRefactoring(project);
    }

    private static boolean isRefasterRefactoring(Project project) {
        return project.hasProperty(PROP_REFASTER_APPLY);
    }

    private static boolean isErrorProneRefactoring(Project project) {
        return project.hasProperty(PROP_ERROR_PRONE_APPLY);
    }

    private static boolean checkExplicitlyDisabled(ErrorProneOptions errorProneOptions, String check) {
        Map checks = (Map)errorProneOptions.getChecks().get();
        return checks.get(check) == CheckSeverity.OFF || ((List)errorProneOptions.getErrorproneArgs().get()).contains(String.format("-Xep:%s:OFF", check));
    }

    private static final class LazyConfigurationList
    extends AbstractList<File> {
        private final FileCollection files;
        private List<File> fileList;

        private LazyConfigurationList(FileCollection files) {
            this.files = files;
        }

        @Override
        public File get(int index) {
            if (this.fileList == null) {
                this.fileList = ImmutableList.copyOf((Collection)this.files.getFiles());
            }
            return this.fileList.get(index);
        }

        @Override
        public int size() {
            if (this.fileList == null) {
                this.fileList = ImmutableList.copyOf((Collection)this.files.getFiles());
            }
            return this.fileList.size();
        }
    }
}

