/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.palantir.baseline.extensions.BaselineJavaVersionExtension;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public final class BaselineJavaVersion
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "javaVersion";

    public void apply(final Project project) {
        final BaselineJavaVersionExtension extension = (BaselineJavaVersionExtension)project.getExtensions().create(EXTENSION_NAME, BaselineJavaVersionExtension.class, new Object[]{project});
        project.getPluginManager().withPlugin("java", unused -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            javaPluginExtension.toolchain((Action)new Action<JavaToolchainSpec>(){

                public void execute(JavaToolchainSpec javaToolchainSpec) {
                    javaToolchainSpec.getLanguageVersion().set(extension.runtime());
                }
            });
            BaselineJavaVersion.configureCompilationTasks(project, extension.target());
            BaselineJavaVersion.configureExecutionTasks(project, extension.runtime());
            project.getTasks().register("checkJavaVersions", CheckJavaVersionsTask.class, (Action)new Action<CheckJavaVersionsTask>(){

                public void execute(CheckJavaVersionsTask task) {
                    task.getTargetVersion().set(extension.target());
                    task.getRuntimeVersion().set(extension.runtime());
                    project.getTasks().getByName("check").dependsOn(new Object[]{task});
                }
            });
        });
    }

    private static void configureCompilationTasks(Project project, final Provider<JavaLanguageVersion> targetVersionProvider) {
        final JavaToolchainService javaToolchainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        project.getTasks().withType(JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile javaCompile) {
                javaCompile.getJavaCompiler().set(javaToolchainService.compilerFor((Action)new Action<JavaToolchainSpec>(){

                    public void execute(JavaToolchainSpec javaToolchainSpec) {
                        javaToolchainSpec.getLanguageVersion().set(targetVersionProvider);
                    }
                }));
            }
        });
        project.getTasks().withType(Javadoc.class, (Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                javadoc.getJavadocTool().set(javaToolchainService.javadocToolFor((Action)new Action<JavaToolchainSpec>(){

                    public void execute(JavaToolchainSpec javaToolchainSpec) {
                        javaToolchainSpec.getLanguageVersion().set(targetVersionProvider);
                    }
                }));
            }
        });
        project.getTasks().withType(GroovyCompile.class, (Action)new Action<GroovyCompile>(){

            public void execute(GroovyCompile groovyCompile) {
                groovyCompile.getJavaLauncher().set(javaToolchainService.launcherFor((Action)new Action<JavaToolchainSpec>(){

                    public void execute(JavaToolchainSpec javaToolchainSpec) {
                        javaToolchainSpec.getLanguageVersion().set(targetVersionProvider);
                    }
                }));
            }
        });
        project.getTasks().withType(ScalaCompile.class, (Action)new Action<ScalaCompile>(){

            public void execute(ScalaCompile scalaCompile) {
                scalaCompile.getJavaLauncher().set(javaToolchainService.launcherFor((Action)new Action<JavaToolchainSpec>(){

                    public void execute(JavaToolchainSpec javaToolchainSpec) {
                        javaToolchainSpec.getLanguageVersion().set(targetVersionProvider);
                    }
                }));
            }
        });
        project.getTasks().withType(ScalaDoc.class, (Action)new Action<ScalaDoc>(){

            public void execute(ScalaDoc scalaDoc) {
                scalaDoc.getJavaLauncher().set(javaToolchainService.launcherFor((Action)new Action<JavaToolchainSpec>(){

                    public void execute(JavaToolchainSpec javaToolchainSpec) {
                        javaToolchainSpec.getLanguageVersion().set(targetVersionProvider);
                    }
                }));
            }
        });
    }

    private static void configureExecutionTasks(Project project, final Provider<JavaLanguageVersion> runtimeVersionProvider) {
        final JavaToolchainService javaToolchainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        project.getTasks().withType(JavaExec.class, (Action)new Action<JavaExec>(){

            public void execute(JavaExec javaExec) {
                javaExec.getJavaLauncher().set(javaToolchainService.launcherFor((Action)new Action<JavaToolchainSpec>(){

                    public void execute(JavaToolchainSpec javaToolchainSpec) {
                        javaToolchainSpec.getLanguageVersion().set(runtimeVersionProvider);
                    }
                }));
            }
        });
        project.getTasks().withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                test.getJavaLauncher().set(javaToolchainService.launcherFor((Action)new Action<JavaToolchainSpec>(){

                    public void execute(JavaToolchainSpec javaToolchainSpec) {
                        javaToolchainSpec.getLanguageVersion().set(runtimeVersionProvider);
                    }
                }));
            }
        });
    }

    @CacheableTask
    public static class CheckJavaVersionsTask
    extends DefaultTask {
        private final Property<JavaLanguageVersion> targetVersion;
        private final Property<JavaLanguageVersion> runtimeVersion;

        @Inject
        public CheckJavaVersionsTask() {
            this.setGroup("Verification");
            this.setDescription("Ensures configured java versions are compatible: The runtime version must be greater than or equal to the target version.");
            this.targetVersion = this.getProject().getObjects().property(JavaLanguageVersion.class);
            this.runtimeVersion = this.getProject().getObjects().property(JavaLanguageVersion.class);
        }

        @Input
        public Property<JavaLanguageVersion> getTargetVersion() {
            return this.targetVersion;
        }

        @Input
        public Property<JavaLanguageVersion> getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @TaskAction
        public final void checkJavaVersions() {
            JavaLanguageVersion target = (JavaLanguageVersion)this.getTargetVersion().get();
            JavaLanguageVersion runtime = (JavaLanguageVersion)this.getRuntimeVersion().get();
            this.getLogger().debug("BaselineJavaVersion configured project {} with target version {} and runtime version {}", new Object[]{this.getProject(), target, runtime});
            if (target.asInt() > runtime.asInt()) {
                throw new GradleException(String.format("The requested compilation target Java version (%s) must not exceed the requested runtime Java version (%s)", target, runtime));
            }
        }
    }
}

