/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.palantir.baseline.extensions.BaselineModuleJvmArgsExtension;
import com.palantir.baseline.plugins.ImmutableJarManifestModuleInfo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.tasks.Jar;
import org.gradle.process.CommandLineArgumentProvider;
import org.immutables.value.Value;

public final class BaselineModuleJvmArgs
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "moduleJvmArgs";
    private static final String ADD_EXPORTS_ATTRIBUTE = "Add-Exports";
    private static final String ADD_OPENS_ATTRIBUTE = "Add-Opens";
    private static final Splitter ENTRY_SPLITTER = Splitter.on((char)' ').trimResults().omitEmptyStrings();

    public void apply(final Project project) {
        project.getPluginManager().withPlugin("java", unused -> {
            final BaselineModuleJvmArgsExtension extension = (BaselineModuleJvmArgsExtension)project.getExtensions().create(EXTENSION_NAME, BaselineModuleJvmArgsExtension.class, new Object[]{project});
            if (project.hasProperty("add.exports.to.javac")) {
                ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).configureEach(sourceSet -> {
                    JavaCompile javaCompile = (JavaCompile)project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class).get();
                    javaCompile.getOptions().getCompilerArgumentProviders().add(new CommandLineArgumentProvider((SourceSet)sourceSet, javaCompile){
                        final /* synthetic */ SourceSet val$sourceSet;
                        final /* synthetic */ JavaCompile val$javaCompile;
                        {
                            this.val$sourceSet = sourceSet;
                            this.val$javaCompile = javaCompile;
                        }

                        public Iterable<String> asArguments() {
                            ImmutableList arguments = BaselineModuleJvmArgs.collectAnnotationProcessorArgs(project, extension, this.val$sourceSet);
                            project.getLogger().debug("BaselineModuleJvmArgs compiling {} on {} with exports: {}", new Object[]{this.val$javaCompile.getName(), project, arguments});
                            return arguments;
                        }
                    });
                });
            }
            project.getTasks().withType(Test.class, (Action)new Action<Test>(){

                public void execute(final Test test) {
                    test.getJvmArgumentProviders().add(new CommandLineArgumentProvider(){

                        public Iterable<String> asArguments() {
                            ImmutableList arguments = BaselineModuleJvmArgs.collectClasspathArgs(project, extension, test.getClasspath());
                            project.getLogger().debug("BaselineModuleJvmArgs executing {} on {} with exports: {}", new Object[]{test.getName(), project, arguments});
                            return arguments;
                        }
                    });
                }
            });
            project.getTasks().withType(JavaExec.class, (Action)new Action<JavaExec>(){

                public void execute(final JavaExec javaExec) {
                    javaExec.getJvmArgumentProviders().add(new CommandLineArgumentProvider(){

                        public Iterable<String> asArguments() {
                            ImmutableList arguments = BaselineModuleJvmArgs.collectClasspathArgs(project, extension, javaExec.getClasspath());
                            project.getLogger().debug("BaselineModuleJvmArgs executing {} on {} with exports: {}", new Object[]{javaExec.getName(), project, arguments});
                            return arguments;
                        }
                    });
                }
            });
            project.getTasks().withType(Jar.class, (Action)new Action<Jar>(){

                public void execute(final Jar jar) {
                    jar.doFirst((Action)new Action<Task>(){

                        public void execute(Task task) {
                            jar.manifest((Action)new Action<Manifest>(){

                                public void execute(Manifest manifest) {
                                    BaselineModuleJvmArgs.addManifestAttribute(jar, manifest, BaselineModuleJvmArgs.ADD_EXPORTS_ATTRIBUTE, (SetProperty<String>)extension.exports());
                                    BaselineModuleJvmArgs.addManifestAttribute(jar, manifest, BaselineModuleJvmArgs.ADD_OPENS_ATTRIBUTE, (SetProperty<String>)extension.opens());
                                }
                            });
                        }
                    });
                }
            });
        });
    }

    private static void addManifestAttribute(Jar jarTask, Manifest manifest, String attributeName, SetProperty<String> valueProperty) {
        Project project = jarTask.getProject();
        Set values = (Set)valueProperty.get();
        if (!values.isEmpty()) {
            project.getLogger().debug("BaselineModuleJvmArgs adding {} attribute to {} in {}: {}", new Object[]{attributeName, jarTask.getName(), project, values});
            manifest.attributes((Map)ImmutableMap.of((Object)attributeName, (Object)String.join((CharSequence)" ", values)));
        } else {
            project.getLogger().debug("BaselineModuleJvmArgs not adding {} attribute to {} in {}", new Object[]{attributeName, jarTask.getName(), project});
        }
    }

    private static ImmutableList<String> collectAnnotationProcessorArgs(Project project, BaselineModuleJvmArgsExtension extension, SourceSet sourceSet) {
        return BaselineModuleJvmArgs.collectClasspathArgs(project, extension, (FileCollection)project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName()));
    }

    private static ImmutableList<String> collectClasspathArgs(Project project, BaselineModuleJvmArgsExtension extension, FileCollection classpath) {
        ImmutableList classpathInfo = (ImmutableList)classpath.getFiles().stream().map(file -> {
            JarManifestModuleInfo jarManifestModuleInfo;
            if (!file.getName().endsWith(".jar") || !file.isFile()) return null;
            JarFile jar = new JarFile((File)file);
            try {
                java.util.jar.Manifest maybeJarManifest = jar.getManifest();
                Optional<JarManifestModuleInfo> parsedModuleInfo = BaselineModuleJvmArgs.parseModuleInfo(maybeJarManifest);
                project.getLogger().debug("Jar '{}' produced manifest info: {}", file, parsedModuleInfo);
                jarManifestModuleInfo = parsedModuleInfo.orElse(null);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jar.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    project.getLogger().warn("Failed to check jar {} for manifest attributes", file, (Object)e);
                    return null;
                }
            }
            jar.close();
            return jarManifestModuleInfo;
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        Stream exports = Stream.concat(((Set)extension.exports().get()).stream(), classpathInfo.stream().flatMap(info -> info.exports().stream())).distinct().sorted().flatMap(BaselineModuleJvmArgs::addExportArg);
        Stream opens = Stream.concat(((Set)extension.opens().get()).stream(), classpathInfo.stream().flatMap(info -> info.opens().stream())).distinct().sorted().flatMap(BaselineModuleJvmArgs::addOpensArg);
        return (ImmutableList)Stream.concat(exports, opens).collect(ImmutableList.toImmutableList());
    }

    private static Optional<JarManifestModuleInfo> parseModuleInfo(@Nullable java.util.jar.Manifest jarManifest) {
        return Optional.ofNullable(jarManifest).map(manifest -> JarManifestModuleInfo.builder().exports(BaselineModuleJvmArgs.readManifestAttribute(manifest, ADD_EXPORTS_ATTRIBUTE)).opens(BaselineModuleJvmArgs.readManifestAttribute(manifest, ADD_OPENS_ATTRIBUTE)).build()).filter(JarManifestModuleInfo::isPresent);
    }

    private static List<String> readManifestAttribute(java.util.jar.Manifest jarManifest, String attribute) {
        return Optional.ofNullable(Strings.emptyToNull((String)jarManifest.getMainAttributes().getValue(attribute))).map(arg_0 -> ((Splitter)ENTRY_SPLITTER).splitToList(arg_0)).orElseGet(ImmutableList::of);
    }

    private static Stream<String> addExportArg(String modulePackagePair) {
        return Stream.of("--add-exports", modulePackagePair + "=ALL-UNNAMED");
    }

    private static Stream<String> addOpensArg(String modulePackagePair) {
        return Stream.of("--add-opens", modulePackagePair + "=ALL-UNNAMED");
    }

    @Value.Immutable
    static interface JarManifestModuleInfo {
        public ImmutableList<String> exports();

        public ImmutableList<String> opens();

        default public boolean isEmpty() {
            return this.exports().isEmpty() && this.opens().isEmpty();
        }

        default public boolean isPresent() {
            return !this.isEmpty();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends ImmutableJarManifestModuleInfo.Builder {
        }
    }
}

