/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.services;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.slf4j.Logger;

public abstract class JarClassHasher
implements BuildService<BuildServiceParameters.None>,
AutoCloseable {
    private final Cache<ModuleVersionIdentifier, Result> cache = Caffeine.newBuilder().build();

    public final Result hashClasses(ResolvedArtifact resolvedArtifact, Logger logger) {
        return (Result)this.cache.get((Object)resolvedArtifact.getModuleVersion().getId(), _moduleId -> {
            File file = resolvedArtifact.getFile();
            if (!file.exists()) {
                return Result.empty();
            }
            ImmutableListMultimap.Builder hashesByClassName = ImmutableListMultimap.builder();
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 JarInputStream jarInputStream = new JarInputStream(fileInputStream);){
                JarEntry entry2;
                while ((entry2 = jarInputStream.getNextJarEntry()) != null) {
                    if (entry2.isDirectory() || !entry2.getName().endsWith(".class") || entry2.getName().contains("module-info.class")) continue;
                    String className = entry2.getName().replaceAll("/", ".").replaceAll("\\.class$", "");
                    HashingInputStream inputStream = new HashingInputStream(Hashing.sha256(), (InputStream)jarInputStream);
                    ByteStreams.exhaust((InputStream)inputStream);
                    hashesByClassName.put((Object)className, (Object)inputStream.hash());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ImmutableListMultimap builtHashesByClassName = hashesByClassName.build();
            List keysWithDuplicateEntries = builtHashesByClassName.asMap().entrySet().stream().filter(entry -> ((Collection)entry.getValue()).size() > 1).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
            if (!keysWithDuplicateEntries.isEmpty()) {
                logger.warn("Warning: Gradle Baseline found a dependency jar that contains more than one zip entry for a class and is likely malformed: {}\nThe following entries appear multiple times: {}\nThis issue should be reported to the maintainer of the dependency.", (Object)resolvedArtifact.getModuleVersion(), keysWithDuplicateEntries);
            }
            return new Result(ImmutableSetMultimap.copyOf((Multimap)builtHashesByClassName));
        });
    }

    @Override
    public final void close() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    public static final class Result {
        private final ImmutableSetMultimap<String, HashCode> hashesByClassName;

        private Result(ImmutableSetMultimap<String, HashCode> hashesByClassName) {
            this.hashesByClassName = hashesByClassName;
        }

        public ImmutableSetMultimap<String, HashCode> getHashesByClassName() {
            return this.hashesByClassName;
        }

        public static Result empty() {
            return new Result((ImmutableSetMultimap<String, HashCode>)ImmutableSetMultimap.of());
        }
    }
}

