/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.compile.JavaCompile;

public final class BaselineJavaCompilerDiagnostics
implements Plugin<Project> {
    private static final String MANY = "10000";
    private static final String MAX_WARNINGS_ARG = "-Xmaxwarns";
    private static final String MAX_ERRORS_ARG = "-Xmaxerrs";

    public void apply(Project proj) {
        proj.afterEvaluate(project -> project.getTasks().withType(JavaCompile.class).configureEach(javaCompileTask -> {
            List compilerArgs = javaCompileTask.getOptions().getCompilerArgs();
            if (!compilerArgs.contains(MAX_WARNINGS_ARG)) {
                compilerArgs.add(MAX_WARNINGS_ARG);
                compilerArgs.add(MANY);
            }
            if (!compilerArgs.contains(MAX_ERRORS_ARG)) {
                compilerArgs.add(MAX_ERRORS_ARG);
                compilerArgs.add(MANY);
            }
        }));
    }
}

