/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.collect.ImmutableSet;
import com.palantir.baseline.plugins.BaselineExactDependencies;
import com.palantir.baseline.tasks.CheckJUnitDependencies;
import com.palantir.baseline.tasks.CheckUnusedDependenciesTask;
import com.palantir.baseline.util.VersionUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentResult;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaselineTesting
implements Plugin<Project> {
    private static final Logger log = LoggerFactory.getLogger(BaselineTesting.class);

    public void apply(Project project) {
        project.getTasks().withType(Test.class).configureEach(task -> {
            task.jvmArgs(new Object[]{"-XX:+HeapDumpOnOutOfMemoryError", "-XX:+CrashOnOutOfMemoryError"});
            if (!Objects.equals("true", project.findProperty("com.palantir.baseline.restore-test-cache"))) {
                task.getOutputs().cacheIf(t -> false);
            }
            boolean shouldRecreate = Boolean.getBoolean("recreate");
            task.systemProperty("recreate", (Object)Boolean.toString(shouldRecreate));
            if (shouldRecreate) {
                task.getOutputs().upToDateWhen(t -> false);
            }
        });
        project.getPlugins().withType(JavaPlugin.class, unusedPlugin -> {
            TaskProvider checkJUnitDependencies = project.getTasks().register("checkJUnitDependencies", CheckJUnitDependencies.class);
            ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().configureEach(sourceSet -> {
                BaselineTesting.getTestTaskForSourceSet(project, sourceSet).ifPresent(testTask -> testTask.dependsOn(new Object[]{checkJUnitDependencies}));
                BaselineTesting.ifHasResolvedCompileDependenciesMatching(project, sourceSet, (com.google.common.base.Predicate<ModuleComponentIdentifier>)((com.google.common.base.Predicate)BaselineTesting::requiresJunitPlatform), () -> this.fixSourceSet(project, (SourceSet)sourceSet));
            });
        });
    }

    private void fixSourceSet(Project project, SourceSet ss) {
        Optional<Test> maybeTestTask = BaselineTesting.getTestTaskForSourceSet(project, ss);
        if (!maybeTestTask.isPresent()) {
            log.warn("Detected 'org:junit.jupiter:junit-jupiter', but unable to find test task");
            return;
        }
        log.info("Detected 'org:junit.jupiter:junit-jupiter', enabling useJUnitPlatform() on {}", (Object)maybeTestTask.get().getName());
        BaselineTesting.enableJunit5ForTestTask(maybeTestTask.get());
        project.getPlugins().withType(BaselineExactDependencies.class, exactDeps -> {
            TaskContainer tasks = project.getTasks();
            tasks.named(BaselineExactDependencies.checkUnusedDependenciesNameForSourceSet(ss), CheckUnusedDependenciesTask.class, task -> task.ignore("org.junit.jupiter", "junit-jupiter"));
        });
    }

    public static Optional<Test> getTestTaskForSourceSet(Project proj, SourceSet ss) {
        String testTaskName = ss.getTaskName(null, "test");
        Task task1 = (Task)proj.getTasks().findByName(testTaskName);
        if (task1 instanceof Test) {
            return Optional.of((Test)task1);
        }
        Task task2 = (Task)proj.getTasks().findByName(ss.getName());
        if (task2 instanceof Test) {
            return Optional.of((Test)task2);
        }
        return Optional.empty();
    }

    private static void ifHasResolvedCompileDependenciesMatching(Project project, SourceSet sourceSet, com.google.common.base.Predicate<ModuleComponentIdentifier> spec, Runnable runnable) {
        project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName()).getIncoming().afterResolve(deps -> {
            boolean anyMatch = deps.getResolutionResult().getAllComponents().stream().map(ComponentResult::getId).filter(componentId -> componentId instanceof ModuleComponentIdentifier).map(componentId -> (ModuleComponentIdentifier)componentId).anyMatch((Predicate<ModuleComponentIdentifier>)spec);
            if (anyMatch) {
                runnable.run();
            }
        });
    }

    private static boolean requiresJunitPlatform(ModuleComponentIdentifier dep) {
        return BaselineTesting.isDep(dep, "org.junit.jupiter", "junit-jupiter") || BaselineTesting.isDep(dep, "org.spockframework", "spock-core") && VersionUtils.majorVersionNumber(dep.getVersion()) >= 2;
    }

    private static boolean isDep(ModuleComponentIdentifier dep, String group, String name) {
        return group.equals(dep.getGroup()) && name.equals(dep.getModule());
    }

    private static void enableJunit5ForTestTask(Test task) {
        if (!BaselineTesting.useJUnitPlatformEnabled(task)) {
            task.useJUnitPlatform();
        }
        task.systemProperty("junit.platform.output.capture.stdout", (Object)"true");
        task.systemProperty("junit.platform.output.capture.stderr", (Object)"true");
        task.systemProperty("junit.jupiter.execution.parallel.enabled", (Object)"true");
        task.systemProperty("junit.jupiter.execution.parallel.config.strategy", (Object)"dynamic");
        task.getTestLogging().getEvents().add(TestLogEvent.FAILED);
        if (!task.getName().equals("test") && "true".equals(System.getenv("CI"))) {
            task.getTestLogging().getEvents().addAll(ImmutableSet.of((Object)TestLogEvent.STARTED, (Object)TestLogEvent.PASSED, (Object)TestLogEvent.SKIPPED));
        }
    }

    public static boolean useJUnitPlatformEnabled(Test task) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.3")) < 0) {
            return task.getOptions() instanceof JUnitPlatformOptions;
        }
        Property<TestFramework> testFramework = BaselineTesting.getTestFrameworkWithReflection(task);
        return testFramework.isPresent() && ((TestFramework)testFramework.get()).getOptions() instanceof JUnitPlatformOptions;
    }

    private static Property<TestFramework> getTestFrameworkWithReflection(Test task) {
        try {
            Method getTestFrameworkProperty = Test.class.getMethod("getTestFrameworkProperty", new Class[0]);
            return (Property)getTestFrameworkProperty.invoke((Object)task, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error calling Test#getTestFrameworkProperty reflectively on Gradle version %s", GradleVersion.current()), e);
        }
    }
}

