/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;

public final class BaselineCheckstyle
extends AbstractBaselinePlugin {
    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(CheckstylePlugin.class);
        project.getExtensions().configure(CheckstyleExtension.class, ext -> ext.setToolVersion(BaselineCheckstyle.getCheckstyleVersionFromResource()));
        project.getPluginManager().withPlugin("java", plugin -> {
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            if (javaConvention.getSourceCompatibility().isJava8Compatible()) {
                project.getTasks().withType(Javadoc.class).configureEach(javadoc -> javadoc.options(javadocOptions -> ((StandardJavadocDocletOptions)javadocOptions).addStringOption("Xdoclint:none", "-quiet")));
            }
        });
        ((CheckstyleExtension)project.getExtensions().getByType(CheckstyleExtension.class)).getConfigDirectory().set(this.project.file((Object)Paths.get(this.getConfigDir(), "checkstyle").toString()));
        project.getPluginManager().withPlugin("eclipse", plugin -> {
            EclipseProject eclipseProject = ((EclipseModel)project.getExtensions().getByType(EclipseModel.class)).getProject();
            eclipseProject.buildCommand("net.sf.eclipsecs.core.CheckstyleBuilder");
        });
        project.getConfigurations().getByName("checkstyle", configuration -> configuration.getResolutionStrategy().getCapabilitiesResolution().withCapability((Object)"com.google.collections:google-collections", details -> details.select((Object)"com.google.guava:guava:0")));
    }

    private static String getCheckstyleVersionFromResource() {
        URL url = Resources.getResource(BaselineCheckstyle.class, (String)"/checkstyle.version");
        Preconditions.checkNotNull((Object)url, (Object)"Unable to find 'checkstyle.version' resource");
        try {
            return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to lookup checkstyle version", e);
        }
    }
}

