/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.palantir.baseline.extensions.BaselineErrorProneExtension;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ltgt.gradle.errorprone.CheckSeverity;
import net.ltgt.gradle.errorprone.ErrorProneOptions;
import net.ltgt.gradle.errorprone.ErrorPronePlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;

public final class BaselineErrorProne
implements Plugin<Project> {
    private static final Logger log = Logging.getLogger(BaselineErrorProne.class);
    public static final String EXTENSION_NAME = "baselineErrorProne";
    private static final String PROP_ERROR_PRONE_APPLY = "errorProneApply";
    private static final String DISABLE_PROPERTY = "com.palantir.baseline-error-prone.disable";

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", unused -> BaselineErrorProne.applyToJavaProject(project));
    }

    private static void applyToJavaProject(Project project) {
        BaselineErrorProneExtension errorProneExtension = (BaselineErrorProneExtension)project.getExtensions().create(EXTENSION_NAME, BaselineErrorProneExtension.class, new Object[]{project});
        project.getPluginManager().apply(ErrorPronePlugin.class);
        String version = Optional.ofNullable(BaselineErrorProne.class.getPackage().getImplementationVersion()).orElseGet(() -> {
            log.warn("Baseline is using 'latest.release' - beware this compromises build reproducibility");
            return "latest.release";
        });
        project.getDependencies().add("errorprone", (Object)("com.palantir.baseline:baseline-error-prone:" + version));
        project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> ((ExtensionAware)javaCompile.getOptions()).getExtensions().configure(ErrorProneOptions.class, errorProneOptions -> BaselineErrorProne.configureErrorProneOptions(project, errorProneExtension, javaCompile, errorProneOptions)));
        project.afterEvaluate(unused -> project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> {
            if (BaselineErrorProne.isErrorProneRefactoring(project)) {
                javaCompile.getOptions().setWarnings(false);
                javaCompile.getOptions().setDeprecation(false);
                javaCompile.getOptions().setCompilerArgs(javaCompile.getOptions().getCompilerArgs().stream().filter(arg -> !arg.equals("-Werror")).filter(arg -> !arg.equals("-deprecation")).filter(arg -> !arg.equals("-Xlint:deprecation")).collect(Collectors.toList()));
            }
        }));
        project.getPluginManager().withPlugin("java-gradle-plugin", appliedPlugin -> project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> ((ExtensionAware)javaCompile.getOptions()).getExtensions().configure(ErrorProneOptions.class, errorProneOptions -> {
            errorProneOptions.disable(new String[]{"CatchBlockLogException"});
            errorProneOptions.disable(new String[]{"JavaxInjectOnAbstractMethod"});
            errorProneOptions.disable(new String[]{"PreconditionsConstantMessage"});
            errorProneOptions.disable(new String[]{"PreferSafeLoggableExceptions"});
            errorProneOptions.disable(new String[]{"PreferSafeLogger"});
            errorProneOptions.disable(new String[]{"PreferSafeLoggingPreconditions"});
            errorProneOptions.disable(new String[]{"Slf4jConstantLogMessage"});
            errorProneOptions.disable(new String[]{"Slf4jLogsafeArgs"});
        })));
    }

    private static void configureErrorProneOptions(final Project project, final BaselineErrorProneExtension errorProneExtension, final JavaCompile javaCompile, final ErrorProneOptions errorProneOptions) {
        if (BaselineErrorProne.isDisabled(project)) {
            errorProneOptions.getEnabled().set((Object)false);
        }
        errorProneOptions.getDisableWarningsInGeneratedCode().set((Object)true);
        errorProneOptions.getExcludedPaths().set((Object)BaselineErrorProne.excludedPathsRegex());
        errorProneOptions.disable(new String[]{"AutoCloseableMustBeClosed", "CatchSpecificity", "CanIgnoreReturnValueSuggester", "InlineMeSuggester", "NotJavadoc", "PreferImmutableStreamExCollections", "StringCaseLocaleUsage", "UnnecessaryTestMethodPrefix", "UnusedVariable", "Varifier", "YodaCondition", "MultipleNullnessAnnotations", "NullableTypeParameter", "NullableWildcard", "SuperCallToObjectMethod"});
        errorProneOptions.error(new String[]{"EqualsHashCode", "EqualsIncompatibleType", "StreamResourceLeak", "InputStreamSlowMultibyteRead", "JavaDurationGetSecondsGetNano", "URLEqualsHashCode", "BoxedPrimitiveEquality", "ReferenceEquality"});
        if (((Boolean)errorProneOptions.getCompilingTestOnlyCode().get()).booleanValue()) {
            errorProneOptions.disable(new String[]{"UnnecessaryLambda"});
        }
        if (BaselineErrorProne.isErrorProneRefactoring(project)) {
            javaCompile.getOutputs().cacheIf(t -> false);
            final Optional maybeSourceSet = (Optional)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().matching(ss -> javaCompile.getName().equals(ss.getCompileJavaTaskName())).stream().collect(MoreCollectors.toOptional());
            errorProneOptions.getErrorproneArgumentProviders().add(new CommandLineArgumentProvider(){

                public Iterable<String> asArguments() {
                    Optional<List<String>> specificChecks = BaselineErrorProne.getSpecificErrorProneChecks(project);
                    if (specificChecks.isPresent()) {
                        List<String> errorProneChecks = specificChecks.get();
                        return Iterables.concat((Iterable)errorProneChecks.stream().map(checkName -> "-Xep:" + checkName + ":ERROR").collect(Collectors.toList()), (Iterable)ImmutableList.of((Object)("-XepPatchChecks:" + Joiner.on((char)',').join(errorProneChecks)), (Object)"-XepPatchLocation:IN_PLACE"));
                    }
                    Stream<String> errorProneChecks = BaselineErrorProne.getNotDisabledErrorproneChecks(project, errorProneExtension, javaCompile, maybeSourceSet, errorProneOptions);
                    return ImmutableList.of((Object)("-XepPatchChecks:" + Joiner.on((char)',').join(errorProneChecks.iterator())), (Object)"-XepPatchLocation:IN_PLACE");
                }
            });
        }
    }

    static String excludedPathsRegex() {
        return ".*/(build|generated_.*[sS]rc|src/generated.*)/.*";
    }

    private static Optional<List<String>> getSpecificErrorProneChecks(Project project) {
        return Optional.ofNullable(project.findProperty(PROP_ERROR_PRONE_APPLY)).map(Objects::toString).flatMap(value -> Optional.ofNullable(Strings.emptyToNull((String)value))).map(value -> Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)value)).flatMap(list -> list.isEmpty() ? Optional.empty() : Optional.of(list));
    }

    private static Stream<String> getNotDisabledErrorproneChecks(Project project, BaselineErrorProneExtension errorProneExtension, JavaCompile javaCompile, Optional<SourceSet> maybeSourceSet, ErrorProneOptions errorProneOptions) {
        Predicate<String> filterOutPreconditions = maybeSourceSet.map(ss -> {
            Configuration configuration = (Configuration)project.getConfigurations().findByName(ss.getCompileClasspathConfigurationName());
            if (configuration == null) {
                return null;
            }
            return BaselineErrorProne.filterOutPreconditions(configuration).and(BaselineErrorProne.filterOutSafeLogger(configuration));
        }).orElse(check -> true);
        return ((List)errorProneExtension.getPatchChecks().get()).stream().filter(check -> {
            if (BaselineErrorProne.checkExplicitlyDisabled(errorProneOptions, check)) {
                log.info("Task {}: not applying errorprone check {} because it has severity OFF in errorProneOptions", (Object)javaCompile.getPath(), check);
                return false;
            }
            return filterOutPreconditions.test((String)check);
        });
    }

    private static boolean hasDependenciesMatching(Configuration configuration, Spec<ModuleComponentIdentifier> spec) {
        return !Iterables.isEmpty((Iterable)configuration.getIncoming().artifactView(viewConfiguration -> viewConfiguration.componentFilter(ci -> ci instanceof ModuleComponentIdentifier && spec.isSatisfiedBy((Object)((ModuleComponentIdentifier)ci)))).getArtifacts());
    }

    public static Predicate<String> filterOutPreconditions(Configuration compileClasspath) {
        return BaselineErrorProne.filterOutBasedOnDependency(compileClasspath, "com.palantir.safe-logging", "preconditions", "PreferSafeLoggingPreconditions", "PreferSafeLoggableExceptions");
    }

    private static Predicate<String> filterOutSafeLogger(Configuration compileClasspath) {
        return BaselineErrorProne.filterOutBasedOnDependency(compileClasspath, "com.palantir.safe-logging", "logger", "PreferSafeLogger");
    }

    private static Predicate<String> filterOutBasedOnDependency(Configuration compileClasspath, String dependencyGroup, String dependencyModule, String ... checkNames) {
        boolean hasDependency = BaselineErrorProne.hasDependenciesMatching(compileClasspath, (Spec<ModuleComponentIdentifier>)((Spec)mci -> Objects.equals(mci.getGroup(), dependencyGroup) && Objects.equals(mci.getModule(), dependencyModule)));
        return check -> {
            if (!hasDependency) {
                for (String checkName : checkNames) {
                    if (!Objects.equals(checkName, check)) continue;
                    log.info("Disabling check {} as '{}:{}' missing from {}", new Object[]{checkName, dependencyGroup, dependencyModule, compileClasspath});
                    return false;
                }
            }
            return true;
        };
    }

    private static boolean isErrorProneRefactoring(Project project) {
        return project.hasProperty(PROP_ERROR_PRONE_APPLY);
    }

    private static boolean isDisabled(Project project) {
        Object disable = project.findProperty(DISABLE_PROPERTY);
        if (disable == null) {
            return false;
        }
        return !disable.equals("false");
    }

    private static boolean checkExplicitlyDisabled(ErrorProneOptions errorProneOptions, String check) {
        Map checks = (Map)errorProneOptions.getChecks().get();
        return checks.get(check) == CheckSeverity.OFF || ((List)errorProneOptions.getErrorproneArgs().get()).contains(String.format("-Xep:%s:OFF", check));
    }
}

