/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.palantir.baseline.tasks.CheckImplicitDependenciesParentTask;
import com.palantir.baseline.tasks.CheckImplicitDependenciesTask;
import com.palantir.baseline.tasks.CheckUnusedDependenciesParentTask;
import com.palantir.baseline.tasks.CheckUnusedDependenciesTask;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.shared.dependency.analyzer.ClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DefaultClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.asm.ASMDependencyAnalyzer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GUtil;

public final class BaselineExactDependencies
implements Plugin<Project> {
    private static final ClassAnalyzer JAR_ANALYZER = new DefaultClassAnalyzer();
    private static final DependencyAnalyzer CLASS_FILE_ANALYZER = new ASMDependencyAnalyzer();
    public static final Indexes INDEXES = new Indexes();
    public static final ImmutableSet<String> VALID_ARTIFACT_EXTENSIONS = ImmutableSet.of((Object)"jar", (Object)"");

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            TaskProvider checkUnusedDependencies = project.getTasks().register("checkUnusedDependencies", CheckUnusedDependenciesParentTask.class);
            TaskProvider checkImplicitDependencies = project.getTasks().register("checkImplicitDependencies", CheckImplicitDependenciesParentTask.class);
            ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().configureEach(sourceSet -> BaselineExactDependencies.configureSourceSet(project, sourceSet, (TaskProvider<CheckUnusedDependenciesParentTask>)checkUnusedDependencies, (TaskProvider<CheckImplicitDependenciesParentTask>)checkImplicitDependencies));
        });
    }

    private static void configureSourceSet(Project project, SourceSet sourceSet, TaskProvider<CheckUnusedDependenciesParentTask> checkUnusedDependencies, TaskProvider<CheckImplicitDependenciesParentTask> checkImplicitDependencies) {
        NamedDomainObjectProvider implementation = project.getConfigurations().named(sourceSet.getImplementationConfigurationName());
        NamedDomainObjectProvider compileClasspath = project.getConfigurations().named(sourceSet.getCompileClasspathConfigurationName());
        NamedDomainObjectProvider explicitCompile = project.getConfigurations().register("baseline-exact-dependencies-" + sourceSet.getName(), conf -> {
            conf.setDescription(String.format("Tracks the explicit (not inherited) dependencies added to either %s or compile (deprecated)", sourceSet.getImplementationConfigurationName()));
            conf.setVisible(false);
            conf.setCanBeConsumed(false);
            conf.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-api")));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)project.getObjects().named(LibraryElements.class, "classes")));
            });
            conf.withDependencies(deps -> {
                if (project.getRootProject().getPluginManager().hasPlugin("com.palantir.versions-lock")) {
                    conf.extendsFrom(new Configuration[]{project.getConfigurations().getByName("lockConstraints")});
                }
                ((Configuration)compileClasspath.get()).getExcludeRules().forEach(rule -> conf.exclude(BaselineExactDependencies.excludeRuleAsMap(rule)));
            });
            AtomicBoolean projectsEvaluated = new AtomicBoolean();
            project.getGradle().projectsEvaluated(g -> projectsEvaluated.set(true));
            conf.getIncoming().beforeResolve(ir -> Preconditions.checkState((projectsEvaluated.get() || project.getGradle().getStartParameter().isConfigureOnDemand() && project.getState().getExecuted() ? 1 : 0) != 0, (String)"Tried to resolve %s too early.", (Object)conf));
        });
        project.afterEvaluate(p -> {
            Configuration implCopy = ((Configuration)implementation.get()).copy();
            project.getConfigurations().add((Object)implCopy);
            ((Configuration)explicitCompile.get()).extendsFrom(new Configuration[]{implCopy});
            Optional<Configuration> maybeCompile = Optional.ofNullable((Configuration)project.getConfigurations().findByName(BaselineExactDependencies.getCompileConfigurationName(sourceSet)));
            maybeCompile.ifPresent(compile -> {
                Configuration compileCopy = compile.copy();
                compileCopy.setCanBeResolved(false);
                compileCopy.setCanBeConsumed(false);
                project.getConfigurations().add((Object)compileCopy);
                ((Configuration)explicitCompile.get()).extendsFrom(new Configuration[]{compileCopy});
            });
        });
        TaskProvider sourceSetUnusedDependencies = project.getTasks().register(BaselineExactDependencies.checkUnusedDependenciesNameForSourceSet(sourceSet), CheckUnusedDependenciesTask.class, task -> {
            task.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            task.setSourceClasses(sourceSet.getOutput().getClassesDirs());
            task.getDependenciesConfigurations().add((Provider)explicitCompile);
            task.ignore((Provider<Set<String>>)project.provider(() -> Set.of(BaselineExactDependencies.ignoreCoordinate(project.getGroup().toString(), project.getName()))));
            task.ignore("javax.annotation", "javax.annotation-api");
            task.ignore("org.junit.jupiter", "junit-jupiter");
            task.ignore(((CheckUnusedDependenciesParentTask)((Object)((Object)checkUnusedDependencies.get()))).getIgnore());
        });
        checkUnusedDependencies.configure(task -> task.dependsOn(new Object[]{sourceSetUnusedDependencies}));
        TaskProvider sourceSetCheckImplicitDependencies = project.getTasks().register("checkImplicitDependencies" + StringUtils.capitalize((String)sourceSet.getName()), CheckImplicitDependenciesTask.class, task -> {
            task.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            task.setSourceClasses(sourceSet.getOutput().getClassesDirs());
            task.getDependenciesConfigurations().add((Provider)compileClasspath);
            task.suggestionConfigurationName(sourceSet.getImplementationConfigurationName());
            task.ignore("org.slf4j", "slf4j-api");
            task.ignore(((CheckImplicitDependenciesParentTask)((Object)((Object)checkImplicitDependencies.get()))).getIgnore());
        });
        checkImplicitDependencies.configure(task -> task.dependsOn(new Object[]{sourceSetCheckImplicitDependencies}));
    }

    static String checkUnusedDependenciesNameForSourceSet(SourceSet sourceSet) {
        return "checkUnusedDependencies" + StringUtils.capitalize((String)sourceSet.getName());
    }

    private static String getCompileConfigurationName(SourceSet sourceSet) {
        String baseName = sourceSet.getName().equals("main") ? "" : GUtil.toCamelCase((CharSequence)sourceSet.getName());
        return StringUtils.uncapitalize((String)(baseName + StringUtils.capitalize((String)"compile")));
    }

    private static Map<String, String> excludeRuleAsMap(ExcludeRule rule) {
        ImmutableMap.Builder excludeRule = ImmutableMap.builder();
        if (rule.getGroup() != null) {
            excludeRule.put((Object)"group", (Object)rule.getGroup());
        }
        if (rule.getModule() != null) {
            excludeRule.put((Object)"module", (Object)rule.getModule());
        }
        return excludeRule.build();
    }

    public static Stream<String> referencedClasses(File classFile) {
        try {
            return CLASS_FILE_ANALYZER.analyze(classFile.toURI().toURL()).stream();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to analyze " + classFile, e);
        }
    }

    public static String asString(ResolvedArtifact artifact) {
        ModuleVersionIdentifier moduleVersionId = artifact.getModuleVersion().getId();
        StringBuilder builder = new StringBuilder().append(moduleVersionId.getGroup()).append(":").append(moduleVersionId.getName());
        if (artifact.getClassifier() != null) {
            builder.append("::").append(artifact.getClassifier());
        }
        return builder.toString();
    }

    public static String asDependencyStringWithName(ResolvedArtifact artifact) {
        return BaselineExactDependencies.asDependencyString(artifact, true);
    }

    public static String asDependencyStringWithoutName(ResolvedArtifact artifact) {
        return BaselineExactDependencies.asDependencyString(artifact, false);
    }

    private static String asDependencyString(ResolvedArtifact artifact, boolean withName) {
        ComponentIdentifier componentId = artifact.getId().getComponentIdentifier();
        if (componentId instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier projectComponentId = (ProjectComponentIdentifier)componentId;
            StringBuilder builder = new StringBuilder().append("project('").append(projectComponentId.getProjectPath()).append("')");
            if (withName) {
                builder.append(" <-- ").append(artifact.getName());
            }
            return builder.toString();
        }
        return BaselineExactDependencies.asString(artifact);
    }

    public static String ignoreCoordinate(String group, String name) {
        return group + ":" + name;
    }

    @ThreadSafe
    public static final class Indexes {
        private final Map<String, Set<ResolvedArtifact>> classToDependency = new ConcurrentHashMap<String, Set<ResolvedArtifact>>();
        private final Map<ResolvedArtifact, Set<String>> classesFromArtifact = new ConcurrentHashMap<ResolvedArtifact, Set<String>>();
        private final Map<ResolvedArtifact, ResolvedDependency> artifactsFromDependency = new ConcurrentHashMap<ResolvedArtifact, ResolvedDependency>();

        public void populateIndexes(Set<ResolvedDependency> declaredDependencies) {
            Set<ResolvedArtifact> allArtifacts = declaredDependencies.stream().flatMap(dependency -> dependency.getAllModuleArtifacts().stream()).filter(dependency -> VALID_ARTIFACT_EXTENSIONS.contains((Object)dependency.getExtension())).collect(Collectors.toSet());
            allArtifacts.forEach(artifact -> {
                try {
                    File jar = artifact.getFile();
                    Set classesInArtifact = JAR_ANALYZER.analyze(jar.toURI().toURL());
                    this.classesFromArtifact.put((ResolvedArtifact)artifact, classesInArtifact);
                    classesInArtifact.forEach(clazz -> this.classToDependency.computeIfAbsent((String)clazz, _ignored -> ConcurrentHashMap.newKeySet()).add(artifact));
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to analyze artifact", e);
                }
            });
            declaredDependencies.forEach(dependency -> dependency.getModuleArtifacts().forEach(artifact -> this.artifactsFromDependency.put((ResolvedArtifact)artifact, (ResolvedDependency)dependency)));
        }

        public Stream<ResolvedArtifact> classToArtifacts(String clazz) {
            return this.classToDependency.getOrDefault(clazz, (Set<ResolvedArtifact>)ImmutableSet.of()).stream();
        }

        public Stream<String> classesFromArtifact(ResolvedArtifact resolvedArtifact) {
            return ((Set)Preconditions.checkNotNull(this.classesFromArtifact.get(resolvedArtifact), (Object)"Unable to find resolved artifact")).stream();
        }

        public ResolvedDependency artifactsFromDependency(ResolvedArtifact resolvedArtifact) {
            return (ResolvedDependency)Preconditions.checkNotNull((Object)this.artifactsFromDependency.get(resolvedArtifact), (Object)"Unable to find resolved artifact");
        }
    }
}

