/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import com.palantir.baseline.services.JarClassHasher;
import com.palantir.baseline.tasks.CheckClassUniquenessLockTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public class BaselineClassUniquenessPlugin
extends AbstractBaselinePlugin {
    public final void apply(Project project) {
        Provider jarClassHasher = project.getGradle().getSharedServices().registerIfAbsent("jarClassHasher", JarClassHasher.class, _spec -> {});
        TaskProvider checkClassUniqueness = project.getTasks().register("checkClassUniqueness", CheckClassUniquenessLockTask.class, task -> {
            task.jarClassHasher.set(jarClassHasher);
            task.shouldFix.convention((Object)project.getGradle().getStartParameter().isWriteDependencyLocks());
            task.usesService(jarClassHasher);
        });
        project.getPlugins().apply(LifecycleBasePlugin.class);
        project.getTasks().named("check").configure(t -> t.dependsOn(new Object[]{checkClassUniqueness}));
        project.getPlugins().withId("java", plugin -> checkClassUniqueness.configure(t -> {
            Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
            t.configurations.add((Object)runtimeClasspath);
            t.dependsOn(new Object[]{runtimeClasspath});
        }));
    }
}

