/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import groovy.util.Node;
import groovy.xml.QName;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.ScalaSourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.plugins.ide.idea.model.IdeaModel;

public final class BaselineScala
extends AbstractBaselinePlugin {
    private static final String SCALA_TARGET_VERSION = "jvm-1.8";

    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().withPlugin("scala", plugin -> {
            JavaPluginExtension javaConvention = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            project.getTasks().withType(ScalaCompile.class).configureEach(scalaCompile -> scalaCompile.getScalaCompileOptions().setAdditionalParameters((List)ImmutableList.of((Object)"-target:jvm-1.8")));
            project.getRootProject().getPluginManager().withPlugin("idea", ideaPlugin -> project.getRootProject().getExtensions().configure(IdeaModel.class, ideaModel -> this.configureIdeaPlugin((IdeaModel)ideaModel, (SourceSet)javaConvention.getSourceSets().named("main").get())));
        });
    }

    private void configureIdeaPlugin(IdeaModel ideaModel, SourceSet mainSourceSet) {
        ScalaSourceDirectorySet scalaSourceDirSet = (ScalaSourceDirectorySet)mainSourceSet.getExtensions().getByType(ScalaSourceDirectorySet.class);
        String compilerMode = scalaSourceDirSet.filter(file -> file.getName().endsWith("java")).isEmpty() ? "JavaThenScala" : "Mixed";
        ideaModel.getProject().getIpr().withXml(xmlProvider -> {
            String targetJvmVersion = "-target:jvm-1.8";
            Node rootNode = xmlProvider.asNode();
            Node scalaCompilerConf = (Node)rootNode.getAt(new QName("component")).stream().filter(o -> ((Node)o).attributes().get("name").equals("ScalaCompilerConfiguration")).findFirst().orElseGet(() -> rootNode.appendNode((Object)"component", (Map)ImmutableMap.of((Object)"name", (Object)"ScalaCompilerConfiguration")));
            Node compilerOrder = (Node)scalaCompilerConf.getAt(new QName("option")).stream().filter(o -> ((Node)o).attributes().get("name").equals("compileOrder")).findFirst().orElseGet(() -> scalaCompilerConf.appendNode((Object)"option"));
            compilerOrder.attributes().put("name", "compileOrder");
            compilerOrder.attributes().put("value", compilerMode);
            Node parametersNode = (Node)scalaCompilerConf.getAt(new QName("parameters")).stream().findFirst().orElseGet(() -> scalaCompilerConf.appendNode((Object)"parameters"));
            Node parameter = (Node)parametersNode.getAt(new QName("parameter")).stream().filter(o -> ((Node)o).attributes().get("value").equals(targetJvmVersion)).findFirst().orElseGet(() -> parametersNode.appendNode((Object)"parameter"));
            parameter.attributes().put("value", targetJvmVersion);
        });
    }
}

