/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.palantir.baseline.extensions.BaselineErrorProneExtension;
import com.palantir.gradle.suppressibleerrorprone.ConditionalPatchCheck;
import com.palantir.gradle.suppressibleerrorprone.IfModuleIsUsed;
import com.palantir.gradle.suppressibleerrorprone.SuppressibleErrorProneExtension;
import com.palantir.gradle.suppressibleerrorprone.SuppressibleErrorPronePlugin;
import java.util.Optional;
import net.ltgt.gradle.errorprone.ErrorProneOptions;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.specs.Spec;

public final class BaselineErrorProne
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "baselineErrorProne";

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", unused -> BaselineErrorProne.applyToJavaProject(project));
    }

    private static void applyToJavaProject(Project project) {
        project.getPluginManager().apply(SuppressibleErrorPronePlugin.class);
        SuppressibleErrorProneExtension suppressibleErrorProneExtension = (SuppressibleErrorProneExtension)project.getExtensions().getByType(SuppressibleErrorProneExtension.class);
        project.getExtensions().create(EXTENSION_NAME, BaselineErrorProneExtension.class, new Object[]{suppressibleErrorProneExtension});
        String version = Optional.ofNullable((String)project.findProperty("baselineErrorProneVersion")).or(() -> Optional.ofNullable(BaselineErrorProne.class.getPackage().getImplementationVersion())).orElseThrow(() -> new RuntimeException("BaselineErrorProne implementation version not found"));
        project.getDependencies().add("errorprone", (Object)("com.palantir.baseline:baseline-error-prone:" + version));
        suppressibleErrorProneExtension.getConditionalPatchChecks().addAll((Object[])new ConditionalPatchCheck[]{new ConditionalPatchCheck((Spec)new IfModuleIsUsed("com.palantir.safe-logging", "preconditions"), new String[]{"PreferSafeLoggingPreconditions", "PreferSafeLoggableExceptions"}), new ConditionalPatchCheck((Spec)new IfModuleIsUsed("com.palantir.safe-logging", "logger"), new String[]{"PreferSafeLogger"})});
        suppressibleErrorProneExtension.configureEachErrorProneOptions(BaselineErrorProne::configureErrorProneOptions);
        project.getPluginManager().withPlugin("java-gradle-plugin", appliedPlugin -> suppressibleErrorProneExtension.configureEachErrorProneOptions(errorProneOptions -> {
            errorProneOptions.disable(new String[]{"CatchBlockLogException"});
            errorProneOptions.disable(new String[]{"JavaxInjectOnAbstractMethod"});
            errorProneOptions.disable(new String[]{"PreconditionsConstantMessage"});
            errorProneOptions.disable(new String[]{"PreferSafeLoggableExceptions"});
            errorProneOptions.disable(new String[]{"PreferSafeLogger"});
            errorProneOptions.disable(new String[]{"PreferSafeLoggingPreconditions"});
            errorProneOptions.disable(new String[]{"Slf4jConstantLogMessage"});
            errorProneOptions.disable(new String[]{"Slf4jLogsafeArgs"});
            errorProneOptions.disable(new String[]{"InjectOnConstructorOfAbstractClass"});
        }));
        project.getPluginManager().withPlugin("org.jetbrains.intellij", appliedPlugin -> suppressibleErrorProneExtension.configureEachErrorProneOptions(errorProneOptions -> {
            errorProneOptions.disable(new String[]{"PreferSafeLogger"});
            errorProneOptions.disable(new String[]{"PreferSafeLoggableExceptions"});
            errorProneOptions.disable(new String[]{"PreferSafeLoggingPreconditions"});
            errorProneOptions.disable(new String[]{"StrictUnusedVariable"});
        }));
    }

    private static void configureErrorProneOptions(ErrorProneOptions errorProneOptions) {
        errorProneOptions.disable(new String[]{"AutoCloseableMustBeClosed", "CatchSpecificity", "CanIgnoreReturnValueSuggester", "DistinctVarargsChecker", "InlineMeSuggester", "NotJavadoc", "PreferImmutableStreamExCollections", "UnnecessaryTestMethodPrefix", "UnusedVariable", "Varifier", "YodaCondition", "MultipleNullnessAnnotations", "NullableTypeParameter", "NullableWildcard", "SuperCallToObjectMethod"});
        errorProneOptions.error(new String[]{"EqualsHashCode", "EqualsIncompatibleType", "StreamResourceLeak", "InputStreamSlowMultibyteRead", "JavaDurationGetSecondsGetNano", "URLEqualsHashCode", "BoxedPrimitiveEquality", "ReferenceEquality"});
        if (((Boolean)errorProneOptions.getCompilingTestOnlyCode().get()).booleanValue()) {
            errorProneOptions.disable(new String[]{"UnnecessaryLambda"});
        }
    }
}

