/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.services;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.baseline.services.ClassUniquenessArtifactIdentifier;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClassUniquenessArtifactIdentifier", generator="Immutables")
@Immutable
public final class ImmutableClassUniquenessArtifactIdentifier
implements ClassUniquenessArtifactIdentifier {
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    @Nullable
    private final String classifier;

    private ImmutableClassUniquenessArtifactIdentifier(ModuleVersionIdentifier moduleVersionIdentifier, @Nullable String classifier) {
        this.moduleVersionIdentifier = moduleVersionIdentifier;
        this.classifier = classifier;
    }

    @Override
    public ModuleVersionIdentifier moduleVersionIdentifier() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public Optional<String> classifier() {
        return Optional.ofNullable(this.classifier);
    }

    public final ImmutableClassUniquenessArtifactIdentifier withModuleVersionIdentifier(ModuleVersionIdentifier value) {
        if (this.moduleVersionIdentifier == value) {
            return this;
        }
        ModuleVersionIdentifier newValue = Objects.requireNonNull(value, "moduleVersionIdentifier");
        return new ImmutableClassUniquenessArtifactIdentifier(newValue, this.classifier);
    }

    public final ImmutableClassUniquenessArtifactIdentifier withClassifier(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.classifier, newValue)) {
            return this;
        }
        return new ImmutableClassUniquenessArtifactIdentifier(this.moduleVersionIdentifier, newValue);
    }

    public final ImmutableClassUniquenessArtifactIdentifier withClassifier(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.classifier, value)) {
            return this;
        }
        return new ImmutableClassUniquenessArtifactIdentifier(this.moduleVersionIdentifier, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClassUniquenessArtifactIdentifier && this.equalTo(0, (ImmutableClassUniquenessArtifactIdentifier)another);
    }

    private boolean equalTo(int synthetic, ImmutableClassUniquenessArtifactIdentifier another) {
        return this.moduleVersionIdentifier.equals(another.moduleVersionIdentifier) && Objects.equals(this.classifier, another.classifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.moduleVersionIdentifier.hashCode();
        h += (h << 5) + Objects.hashCode(this.classifier);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ClassUniquenessArtifactIdentifier").omitNullValues().add("moduleVersionIdentifier", (Object)this.moduleVersionIdentifier).add("classifier", (Object)this.classifier).toString();
    }

    public static ImmutableClassUniquenessArtifactIdentifier copyOf(ClassUniquenessArtifactIdentifier instance) {
        if (instance instanceof ImmutableClassUniquenessArtifactIdentifier) {
            return (ImmutableClassUniquenessArtifactIdentifier)instance;
        }
        return ImmutableClassUniquenessArtifactIdentifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClassUniquenessArtifactIdentifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODULE_VERSION_IDENTIFIER = 1L;
        private long initBits = 1L;
        @Nullable
        private ModuleVersionIdentifier moduleVersionIdentifier;
        @Nullable
        private String classifier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClassUniquenessArtifactIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.moduleVersionIdentifier(instance.moduleVersionIdentifier());
            Optional<String> classifierOptional = instance.classifier();
            if (classifierOptional.isPresent()) {
                this.classifier(classifierOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder moduleVersionIdentifier(ModuleVersionIdentifier moduleVersionIdentifier) {
            this.moduleVersionIdentifier = Objects.requireNonNull(moduleVersionIdentifier, "moduleVersionIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder classifier(@Nullable String classifier) {
            this.classifier = classifier;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder classifier(Optional<String> classifier) {
            this.classifier = classifier.orElse(null);
            return this;
        }

        public ImmutableClassUniquenessArtifactIdentifier build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClassUniquenessArtifactIdentifier(this.moduleVersionIdentifier, this.classifier);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("moduleVersionIdentifier");
            }
            return "Cannot build ClassUniquenessArtifactIdentifier, some of required attributes are not set " + attributes;
        }
    }
}

