/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Failure;
import com.palantir.gradle.junit.ReportHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.reporting.SingleFileReport;
import org.xml.sax.Attributes;

public final class CheckstyleReportHandler
extends ReportHandler<Checkstyle> {
    private final List<Failure> failures = new ArrayList<Failure>();
    private File file;

    @Override
    public void configureTask(Checkstyle task) {
        ((SingleFileReport)task.getReports().findByName("xml")).getRequired().set((Object)true);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName) {
            case "file": {
                this.file = new File(attributes.getValue("name"));
                break;
            }
            case "error": {
                this.failures.add(Failure.builder().source(attributes.getValue("source")).severity(attributes.getValue("severity").toUpperCase()).file(this.file).line(Integer.parseInt(attributes.getValue("line"))).message(attributes.getValue("message")).build());
            }
        }
    }

    @Override
    public List<Failure> failures() {
        return this.failures;
    }
}

