/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.base.Preconditions;
import com.palantir.gradle.junit.BuildFailureListener;
import com.palantir.gradle.junit.BuildFinishedAction;
import com.palantir.gradle.junit.JunitReportsExtension;
import com.palantir.gradle.junit.JunitReportsPlugin;
import com.palantir.gradle.junit.JunitTaskResultExtension;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;

public final class JunitReportsRootPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Preconditions.checkState((boolean)project.getRootProject().equals(project), (Object)"Plugin must only be applied to root project");
        Predicate<Task> isTaskRegistered = task -> ((JunitTaskResultExtension)task.getProject().getExtensions().getByType(JunitTaskResultExtension.class)).getTaskEntries().findByName(task.getName()) != null;
        JunitReportsExtension reportsExtension = JunitReportsExtension.register(project, isTaskRegistered);
        Provider targetFileProvider = reportsExtension.getReportsDirectory().map(dir -> {
            int attemptNumber = 1;
            Path targetFile = dir.getAsFile().toPath().resolve("gradle").resolve("build.xml");
            while (targetFile.toFile().exists()) {
                targetFile = dir.getAsFile().toPath().resolve("gradle").resolve("build" + ++attemptNumber + ".xml");
            }
            return dir.file(targetFile.toAbsolutePath().toString());
        });
        BuildFailureListener listener = new BuildFailureListener(isTaskRegistered);
        BuildFinishedAction action = new BuildFinishedAction((Provider<RegularFile>)targetFileProvider, listener);
        project.getGradle().addListener((Object)listener);
        project.getGradle().buildFinished((Action)action);
        project.allprojects(proj -> proj.getPluginManager().apply(JunitReportsPlugin.class));
    }
}

