/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.palantir.gradle.junit.Report;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class Report_Failure_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private String message;
    private String details;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Report_Failure_Builder() {
    }

    public static Report.Failure.Builder from(Report.Failure value) {
        return new Report.Failure.Builder().mergeFrom(value);
    }

    public Report.Failure.Builder message(String message) {
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this._unsetProperties.remove((Object)Property.MESSAGE);
        return (Report.Failure.Builder)this;
    }

    public Report.Failure.Builder mapMessage(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.message((String)mapper.apply(this.message()));
    }

    public String message() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.MESSAGE) ? 1 : 0) != 0, (Object)"message not set");
        return this.message;
    }

    public Report.Failure.Builder details(String details) {
        this.details = (String)Preconditions.checkNotNull((Object)details);
        this._unsetProperties.remove((Object)Property.DETAILS);
        return (Report.Failure.Builder)this;
    }

    public Report.Failure.Builder mapDetails(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.details((String)mapper.apply(this.details()));
    }

    public String details() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.DETAILS) ? 1 : 0) != 0, (Object)"details not set");
        return this.details;
    }

    public Report.Failure.Builder mergeFrom(Report.Failure value) {
        Report.Failure.Builder _defaults = new Report.Failure.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.MESSAGE) || !Objects.equals(value.message(), ((Report_Failure_Builder)_defaults).message())) {
            this.message(value.message());
        }
        if (_defaults._unsetProperties.contains((Object)Property.DETAILS) || !Objects.equals(value.details(), ((Report_Failure_Builder)_defaults).details())) {
            this.details(value.details());
        }
        return (Report.Failure.Builder)this;
    }

    public Report.Failure.Builder mergeFrom(Report.Failure.Builder template) {
        Report.Failure.Builder base = template;
        Report.Failure.Builder _defaults = new Report.Failure.Builder();
        if (!(base._unsetProperties.contains((Object)Property.MESSAGE) || !_defaults._unsetProperties.contains((Object)Property.MESSAGE) && Objects.equals(template.message(), ((Report_Failure_Builder)_defaults).message()))) {
            this.message(template.message());
        }
        if (!(base._unsetProperties.contains((Object)Property.DETAILS) || !_defaults._unsetProperties.contains((Object)Property.DETAILS) && Objects.equals(template.details(), ((Report_Failure_Builder)_defaults).details()))) {
            this.details(template.details());
        }
        return (Report.Failure.Builder)this;
    }

    public Report.Failure.Builder clear() {
        Report.Failure.Builder _defaults = new Report.Failure.Builder();
        this.message = _defaults.message;
        this.details = _defaults.details;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (Report.Failure.Builder)this;
    }

    public Report.Failure build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public Report.Failure buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements Report.Failure {
        private final String message;
        private final String details;
        private final EnumSet<Property> _unsetProperties;

        Partial(Report_Failure_Builder builder) {
            this.message = builder.message;
            this.details = builder.details;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public String message() {
            if (this._unsetProperties.contains((Object)Property.MESSAGE)) {
                throw new UnsupportedOperationException("message not set");
            }
            return this.message;
        }

        @Override
        public String details() {
            if (this._unsetProperties.contains((Object)Property.DETAILS)) {
                throw new UnsupportedOperationException("details not set");
            }
            return this.details;
        }

        @Override
        public Report.Failure.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            if (!this._unsetProperties.contains((Object)Property.MESSAGE)) {
                builder.message(this.message);
            }
            if (!this._unsetProperties.contains((Object)Property.DETAILS)) {
                builder.details(this.details);
            }
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.message, other.message) && Objects.equals(this.details, other.details) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.details, this._unsetProperties);
        }

        public String toString() {
            return "partial Failure{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.MESSAGE) ? "message=" + this.message : null), (Object)(!this._unsetProperties.contains((Object)Property.DETAILS) ? "details=" + this.details : null), new Object[0]) + "}";
        }

        private static class PartialBuilder
        extends Report.Failure.Builder {
            private PartialBuilder() {
            }

            @Override
            public Report.Failure build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    implements Report.Failure {
        private final String message;
        private final String details;

        private Value(Report_Failure_Builder builder) {
            this.message = builder.message;
            this.details = builder.details;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public String details() {
            return this.details;
        }

        @Override
        public Report.Failure.Builder toBuilder() {
            return new Report.Failure.Builder().mergeFrom(this);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.message, other.message) && Objects.equals(this.details, other.details);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.details);
        }

        public String toString() {
            return "Failure{message=" + this.message + ", details=" + this.details + "}";
        }
    }

    private static enum Property {
        MESSAGE("message"),
        DETAILS("details");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

