/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Failure;
import com.palantir.gradle.junit.Report;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FailuresReportGenerator {
    private static final Pattern JAVA_FILE_RX = Pattern.compile(".*src/\\w+/java/(.*)\\.java");

    private FailuresReportGenerator() {
    }

    public static Report failuresReport(File rootDir, String projectName, String taskName, long elapsedTimeNanos, List<Failure> failures) {
        Report.Builder report = new Report.Builder().elapsedTimeNanos(elapsedTimeNanos).name(projectName).subname(taskName);
        for (Failure failure : failures) {
            String shortSource = failure.source().isEmpty() ? "" : failure.source().replaceAll(".*\\.", "") + " - ";
            String className = FailuresReportGenerator.getClassName(failure.file());
            Report.TestCase testCase = new Report.TestCase.Builder().name(shortSource + className).failure(new Report.Failure.Builder().message(failure.file().getName() + ":" + failure.line() + ": " + failure.message()).details(failure.severity() + ": " + failure.message() + failure.details() + "\n" + (String)(failure.source().isEmpty() ? "" : "Category: " + failure.source() + "\n") + "File: " + FailuresReportGenerator.relativise(rootDir, failure) + "\nLine: " + failure.line() + "\n").build()).build();
            report.addTestCases(testCase);
        }
        return report.build();
    }

    public static Path relativise(File rootDir, Failure failure) {
        try {
            return rootDir.toPath().relativize(failure.file().toPath());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Could not relativise " + failure.file() + " wrt " + rootDir, e);
        }
    }

    private static String getClassName(File file) {
        Matcher matcher = JAVA_FILE_RX.matcher(file.toString());
        if (matcher.matches()) {
            return matcher.group(1).replace('/', '.');
        }
        return file.toString();
    }
}

