/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Failure;
import com.palantir.gradle.junit.FailuresSupplier;
import com.palantir.gradle.junit.ReportHandler;
import com.palantir.gradle.junit.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.reporting.ReportContainer;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.SingleFileReport;

public final class XmlReportFailuresSupplier
implements FailuresSupplier {
    private final Reporting<? extends ReportContainer<SingleFileReport>> reporting;
    private final ReportHandler<?> reportHandler;

    public static <T extends Task & Reporting<? extends ReportContainer<SingleFileReport>>> XmlReportFailuresSupplier create(final T task, final ReportHandler<T> reportHandler) {
        task.getProject().afterEvaluate((Action)new Action<Project>(){

            public void execute(Project _project) {
                reportHandler.configureTask(task);
            }
        });
        return new XmlReportFailuresSupplier(task, reportHandler);
    }

    private XmlReportFailuresSupplier(Reporting<? extends ReportContainer<SingleFileReport>> reporting, ReportHandler<?> reportHandler) {
        this.reporting = reporting;
        this.reportHandler = reportHandler;
    }

    @Override
    public List<Failure> getFailures() throws IOException {
        File sourceReport = Optional.ofNullable((SingleFileReport)this.reporting.getReports().findByName("xml")).map(report -> (File)report.getOutputLocation().getAsFile().getOrNull()).orElseThrow(() -> new RuntimeException("Could not find junit reports"));
        try {
            return XmlUtils.parseXml(this.reportHandler, new FileInputStream(sourceReport)).failures();
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException(String.format("Failed to parse failures XML: %s", sourceReport), e);
        }
    }

    @Override
    public RuntimeException handleInternalFailure(Path reportDir, RuntimeException ex) {
        Path rawReportsDir = reportDir.resolve(UUID.randomUUID().toString());
        try {
            Files.createDirectories(rawReportsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (SingleFileReport rawReport : this.reporting.getReports()) {
            if (!((Boolean)rawReport.getRequired().get()).booleanValue()) continue;
            File rawReportFile = Optional.ofNullable((File)rawReport.getOutputLocation().getAsFile().getOrNull()).orElseThrow(() -> new IllegalStateException("Could not get raw report file: " + rawReport));
            rawReportFile.renameTo(rawReportsDir.resolve(rawReportFile.getName()).toFile());
        }
        return new RuntimeException("Finalizer failed; raw report files can be found at " + rawReportsDir.getFileName().toString(), ex);
    }
}

