/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Report;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.TaskState;

public final class BuildFailureListener
implements TaskExecutionListener {
    private final List<Report.TestCase> testCases = new ArrayList<Report.TestCase>();
    private final Predicate<Task> isTracked;

    public BuildFailureListener(Predicate<Task> isTracked) {
        this.isTracked = isTracked;
    }

    public void beforeExecute(Task _task) {
    }

    public synchronized void afterExecute(Task task, TaskState state) {
        if (!this.isTracked.test(task)) {
            Report.TestCase.Builder testCase = new Report.TestCase.Builder().name(":" + task.getProject().getName() + ":" + task.getName());
            Throwable failure = state.getFailure();
            if (failure != null) {
                if (failure instanceof TaskExecutionException && failure.getCause() != null) {
                    failure = failure.getCause();
                }
                StringWriter stackTrace = new StringWriter();
                failure.printStackTrace(new PrintWriter(stackTrace));
                testCase.failure(new Report.Failure.Builder().message(BuildFailureListener.getMessage(failure)).details(stackTrace.toString()).build());
            }
            this.testCases.add(testCase.build());
        }
    }

    public List<Report.TestCase> getTestCases() {
        return this.testCases;
    }

    private static String getMessage(Throwable throwable) {
        if (throwable.getMessage() == null) {
            return throwable.getClass().getSimpleName();
        }
        return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
    }
}

