/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.gradle.junit.Failure;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Failure", generator="Immutables")
@Immutable
public final class ImmutableFailure
implements Failure {
    private final String source;
    private final File file;
    private final int line;
    private final String severity;
    private final String message;
    private final String details;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFailure(Builder builder) {
        this.file = builder.file;
        this.line = builder.line;
        this.severity = builder.severity;
        this.message = builder.message;
        if (builder.source != null) {
            this.initShim.source(builder.source);
        }
        if (builder.details != null) {
            this.initShim.details(builder.details);
        }
        this.source = this.initShim.source();
        this.details = this.initShim.details();
        this.initShim = null;
    }

    private ImmutableFailure(String source, File file, int line, String severity, String message, String details) {
        this.source = source;
        this.file = file;
        this.line = line;
        this.severity = severity;
        this.message = message;
        this.details = details;
        this.initShim = null;
    }

    private String sourceInitialize() {
        return Failure.super.source();
    }

    private String detailsInitialize() {
        return Failure.super.details();
    }

    @Override
    public String source() {
        InitShim shim = this.initShim;
        return shim != null ? shim.source() : this.source;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public String details() {
        InitShim shim = this.initShim;
        return shim != null ? shim.details() : this.details;
    }

    public final ImmutableFailure withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableFailure(newValue, this.file, this.line, this.severity, this.message, this.details);
    }

    public final ImmutableFailure withFile(File value) {
        if (this.file == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "file");
        return new ImmutableFailure(this.source, newValue, this.line, this.severity, this.message, this.details);
    }

    public final ImmutableFailure withLine(int value) {
        if (this.line == value) {
            return this;
        }
        return new ImmutableFailure(this.source, this.file, value, this.severity, this.message, this.details);
    }

    public final ImmutableFailure withSeverity(String value) {
        String newValue = Objects.requireNonNull(value, "severity");
        if (this.severity.equals(newValue)) {
            return this;
        }
        return new ImmutableFailure(this.source, this.file, this.line, newValue, this.message, this.details);
    }

    public final ImmutableFailure withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableFailure(this.source, this.file, this.line, this.severity, newValue, this.details);
    }

    public final ImmutableFailure withDetails(String value) {
        String newValue = Objects.requireNonNull(value, "details");
        if (this.details.equals(newValue)) {
            return this;
        }
        return new ImmutableFailure(this.source, this.file, this.line, this.severity, this.message, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFailure && this.equalTo(0, (ImmutableFailure)another);
    }

    private boolean equalTo(int synthetic, ImmutableFailure another) {
        return this.source.equals(another.source) && this.file.equals(another.file) && this.line == another.line && this.severity.equals(another.severity) && this.message.equals(another.message) && this.details.equals(another.details);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + this.line;
        h += (h << 5) + this.severity.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.details.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Failure").omitNullValues().add("source", (Object)this.source).add("file", (Object)this.file).add("line", this.line).add("severity", (Object)this.severity).add("message", (Object)this.message).add("details", (Object)this.details).toString();
    }

    public static ImmutableFailure copyOf(Failure instance) {
        if (instance instanceof ImmutableFailure) {
            return (ImmutableFailure)instance;
        }
        return new Failure.Builder().from(instance).build();
    }

    @Generated(from="Failure", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_LINE = 2L;
        private static final long INIT_BIT_SEVERITY = 4L;
        private static final long INIT_BIT_MESSAGE = 8L;
        private long initBits = 15L;
        @Nullable
        private String source;
        @Nullable
        private File file;
        private int line;
        @Nullable
        private String severity;
        @Nullable
        private String message;
        @Nullable
        private String details;

        public Builder() {
            if (!(this instanceof Failure.Builder)) {
                throw new UnsupportedOperationException("Use: new Failure.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final Failure.Builder from(Failure instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.source());
            this.file(instance.file());
            this.line(instance.line());
            this.severity(instance.severity());
            this.message(instance.message());
            this.details(instance.details());
            return (Failure.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Failure.Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            return (Failure.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Failure.Builder file(File file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Failure.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Failure.Builder line(int line) {
            this.line = line;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Failure.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Failure.Builder severity(String severity) {
            this.severity = Objects.requireNonNull(severity, "severity");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (Failure.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Failure.Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (Failure.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Failure.Builder details(String details) {
            this.details = Objects.requireNonNull(details, "details");
            return (Failure.Builder)this;
        }

        public ImmutableFailure build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFailure(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("line");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("severity");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build Failure, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Failure", generator="Immutables")
    private final class InitShim {
        private byte sourceBuildStage = 0;
        private String source;
        private byte detailsBuildStage = 0;
        private String details;

        private InitShim() {
        }

        String source() {
            if (this.sourceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceBuildStage == 0) {
                this.sourceBuildStage = (byte)-1;
                this.source = Objects.requireNonNull(ImmutableFailure.this.sourceInitialize(), "source");
                this.sourceBuildStage = 1;
            }
            return this.source;
        }

        void source(String source) {
            this.source = source;
            this.sourceBuildStage = 1;
        }

        String details() {
            if (this.detailsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.detailsBuildStage == 0) {
                this.detailsBuildStage = (byte)-1;
                this.details = Objects.requireNonNull(ImmutableFailure.this.detailsInitialize(), "details");
                this.detailsBuildStage = 1;
            }
            return this.details;
        }

        void details(String details) {
            this.details = details;
            this.detailsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sourceBuildStage == -1) {
                attributes.add("source");
            }
            if (this.detailsBuildStage == -1) {
                attributes.add("details");
            }
            return "Cannot build Failure, attribute initializers form cycle " + attributes;
        }
    }
}

