/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Failure;
import com.palantir.gradle.junit.FailuresSupplier;
import com.palantir.gradle.junit.ImmutableTaskEntry;
import java.nio.file.Path;
import java.util.List;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.immutables.value.Value;

public class JunitTaskResultExtension {
    static final String NAME = "junitTaskResults";
    private final NamedDomainObjectSet<TaskEntry> taskEntries;

    static JunitTaskResultExtension register(Project project) {
        return (JunitTaskResultExtension)project.getExtensions().create(NAME, JunitTaskResultExtension.class, new Object[0]);
    }

    public JunitTaskResultExtension(ObjectFactory objects) {
        this.taskEntries = objects.namedDomainObjectSet(TaskEntry.class);
    }

    public final NamedDomainObjectSet<TaskEntry> getTaskEntries() {
        return this.taskEntries;
    }

    public final void registerTask(String taskName, final Provider<List<Failure>> failures) {
        this.registerTask(taskName, new FailuresSupplier(){

            @Override
            public List<Failure> getFailures() {
                return (List)failures.get();
            }

            @Override
            public RuntimeException handleInternalFailure(Path _reportDir, RuntimeException ex) {
                return ex;
            }
        });
    }

    public final void registerTask(String taskName, FailuresSupplier failuresSupplier) {
        this.taskEntries.add((Object)TaskEntry.of(taskName, failuresSupplier));
    }

    @Value.Immutable
    static interface TaskEntry {
        public String name();

        public FailuresSupplier failuresSupplier();

        public static TaskEntry of(String name, FailuresSupplier failuresSupplier) {
            return ImmutableTaskEntry.builder().name(name).failuresSupplier(failuresSupplier).build();
        }
    }
}

