/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.palantir.gradle.junit.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class Report_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private String name;
    private String subname;
    private long elapsedTimeNanos;
    private List<Report.TestCase> testCases = ImmutableList.of();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Report_Builder() {
    }

    public static Report.Builder from(Report value) {
        return new Report.Builder().mergeFrom(value);
    }

    public Report.Builder name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (Report.Builder)this;
    }

    public Report.Builder mapName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.name((String)mapper.apply(this.name()));
    }

    public String name() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    public Report.Builder subname(String subname) {
        this.subname = (String)Preconditions.checkNotNull((Object)subname);
        this._unsetProperties.remove((Object)Property.SUBNAME);
        return (Report.Builder)this;
    }

    public Report.Builder mapSubname(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.subname((String)mapper.apply(this.subname()));
    }

    public String subname() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SUBNAME) ? 1 : 0) != 0, (Object)"subname not set");
        return this.subname;
    }

    public Report.Builder elapsedTimeNanos(long elapsedTimeNanos) {
        this.elapsedTimeNanos = elapsedTimeNanos;
        this._unsetProperties.remove((Object)Property.ELAPSED_TIME_NANOS);
        return (Report.Builder)this;
    }

    public Report.Builder mapElapsedTimeNanos(UnaryOperator<Long> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.elapsedTimeNanos((Long)mapper.apply(this.elapsedTimeNanos()));
    }

    public long elapsedTimeNanos() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ELAPSED_TIME_NANOS) ? 1 : 0) != 0, (Object)"elapsedTimeNanos not set");
        return this.elapsedTimeNanos;
    }

    public Report.Builder addTestCases(Report.TestCase element) {
        if (this.testCases instanceof ImmutableList) {
            this.testCases = new ArrayList<Report.TestCase>(this.testCases);
        }
        this.testCases.add((Report.TestCase)Preconditions.checkNotNull((Object)element));
        return (Report.Builder)this;
    }

    public Report.Builder addTestCases(Report.TestCase ... elements) {
        return this.addAllTestCases(Arrays.asList(elements));
    }

    public Report.Builder addAllTestCases(Spliterator<? extends Report.TestCase> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.testCases instanceof ImmutableList) {
                this.testCases = new ArrayList<Report.TestCase>(this.testCases);
            }
            ((ArrayList)this.testCases).ensureCapacity(this.testCases.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addTestCases);
        return (Report.Builder)this;
    }

    public Report.Builder addAllTestCases(BaseStream<? extends Report.TestCase, ?> elements) {
        return this.addAllTestCases(elements.spliterator());
    }

    public Report.Builder addAllTestCases(Iterable<? extends Report.TestCase> elements) {
        return this.addAllTestCases(elements.spliterator());
    }

    public Report.Builder mutateTestCases(Consumer<? super List<Report.TestCase>> mutator) {
        if (this.testCases instanceof ImmutableList) {
            this.testCases = new ArrayList<Report.TestCase>(this.testCases);
        }
        mutator.accept(this.testCases);
        return (Report.Builder)this;
    }

    public Report.Builder clearTestCases() {
        if (this.testCases instanceof ImmutableList) {
            this.testCases = ImmutableList.of();
        } else {
            this.testCases.clear();
        }
        return (Report.Builder)this;
    }

    public List<Report.TestCase> testCases() {
        if (this.testCases instanceof ImmutableList) {
            this.testCases = new ArrayList<Report.TestCase>(this.testCases);
        }
        return Collections.unmodifiableList(this.testCases);
    }

    public Report.Builder mergeFrom(Report value) {
        Report.Builder _defaults = new Report.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.name(), ((Report_Builder)_defaults).name())) {
            this.name(value.name());
        }
        if (_defaults._unsetProperties.contains((Object)Property.SUBNAME) || !Objects.equals(value.subname(), ((Report_Builder)_defaults).subname())) {
            this.subname(value.subname());
        }
        if (_defaults._unsetProperties.contains((Object)Property.ELAPSED_TIME_NANOS) || !Objects.equals(value.elapsedTimeNanos(), ((Report_Builder)_defaults).elapsedTimeNanos())) {
            this.elapsedTimeNanos(value.elapsedTimeNanos());
        }
        if (value instanceof Value && this.testCases == ImmutableList.of()) {
            this.testCases = ImmutableList.copyOf(value.testCases());
        } else {
            this.addAllTestCases(value.testCases());
        }
        return (Report.Builder)this;
    }

    public Report.Builder mergeFrom(Report.Builder template) {
        Report.Builder base = template;
        Report.Builder _defaults = new Report.Builder();
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !_defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.name(), ((Report_Builder)_defaults).name()))) {
            this.name(template.name());
        }
        if (!(base._unsetProperties.contains((Object)Property.SUBNAME) || !_defaults._unsetProperties.contains((Object)Property.SUBNAME) && Objects.equals(template.subname(), ((Report_Builder)_defaults).subname()))) {
            this.subname(template.subname());
        }
        if (!(base._unsetProperties.contains((Object)Property.ELAPSED_TIME_NANOS) || !_defaults._unsetProperties.contains((Object)Property.ELAPSED_TIME_NANOS) && Objects.equals(template.elapsedTimeNanos(), ((Report_Builder)_defaults).elapsedTimeNanos()))) {
            this.elapsedTimeNanos(template.elapsedTimeNanos());
        }
        this.addAllTestCases(base.testCases);
        return (Report.Builder)this;
    }

    public Report.Builder clear() {
        Report.Builder _defaults = new Report.Builder();
        this.name = _defaults.name;
        this.subname = _defaults.subname;
        this.elapsedTimeNanos = _defaults.elapsedTimeNanos;
        this.clearTestCases();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (Report.Builder)this;
    }

    public Report build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public Report buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements Report {
        private final String name;
        private final String subname;
        private final long elapsedTimeNanos;
        private final List<Report.TestCase> testCases;
        private final EnumSet<Property> _unsetProperties;

        Partial(Report_Builder builder) {
            this.name = builder.name;
            this.subname = builder.subname;
            this.elapsedTimeNanos = builder.elapsedTimeNanos;
            this.testCases = ImmutableList.copyOf(builder.testCases);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public String name() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        public String subname() {
            if (this._unsetProperties.contains((Object)Property.SUBNAME)) {
                throw new UnsupportedOperationException("subname not set");
            }
            return this.subname;
        }

        @Override
        public long elapsedTimeNanos() {
            if (this._unsetProperties.contains((Object)Property.ELAPSED_TIME_NANOS)) {
                throw new UnsupportedOperationException("elapsedTimeNanos not set");
            }
            return this.elapsedTimeNanos;
        }

        @Override
        public List<Report.TestCase> testCases() {
            return this.testCases;
        }

        @Override
        public Report.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            if (!this._unsetProperties.contains((Object)Property.NAME)) {
                builder.name(this.name);
            }
            if (!this._unsetProperties.contains((Object)Property.SUBNAME)) {
                builder.subname(this.subname);
            }
            if (!this._unsetProperties.contains((Object)Property.ELAPSED_TIME_NANOS)) {
                builder.elapsedTimeNanos(this.elapsedTimeNanos);
            }
            builder.addAllTestCases(this.testCases);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.subname, other.subname) && Objects.equals(this.elapsedTimeNanos, other.elapsedTimeNanos) && Objects.equals(this.testCases, other.testCases) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.subname, this.elapsedTimeNanos, this.testCases, this._unsetProperties);
        }

        public String toString() {
            return "partial Report{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.NAME) ? "name=" + this.name : null), (Object)(!this._unsetProperties.contains((Object)Property.SUBNAME) ? "subname=" + this.subname : null), new Object[]{!this._unsetProperties.contains((Object)Property.ELAPSED_TIME_NANOS) ? "elapsedTimeNanos=" + this.elapsedTimeNanos : null, "testCases=" + this.testCases}) + "}";
        }

        private static class PartialBuilder
        extends Report.Builder {
            private PartialBuilder() {
            }

            @Override
            public Report build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    implements Report {
        private final String name;
        private final String subname;
        private final long elapsedTimeNanos;
        private final List<Report.TestCase> testCases;

        private Value(Report_Builder builder) {
            this.name = builder.name;
            this.subname = builder.subname;
            this.elapsedTimeNanos = builder.elapsedTimeNanos;
            this.testCases = ImmutableList.copyOf(builder.testCases);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String subname() {
            return this.subname;
        }

        @Override
        public long elapsedTimeNanos() {
            return this.elapsedTimeNanos;
        }

        @Override
        public List<Report.TestCase> testCases() {
            return this.testCases;
        }

        @Override
        public Report.Builder toBuilder() {
            return new Report.Builder().mergeFrom(this);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.subname, other.subname) && Objects.equals(this.elapsedTimeNanos, other.elapsedTimeNanos) && Objects.equals(this.testCases, other.testCases);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.subname, this.elapsedTimeNanos, this.testCases);
        }

        public String toString() {
            return "Report{name=" + this.name + ", subname=" + this.subname + ", elapsedTimeNanos=" + this.elapsedTimeNanos + ", testCases=" + this.testCases + "}";
        }
    }

    private static enum Property {
        NAME("name"),
        SUBNAME("subname"),
        ELAPSED_TIME_NANOS("elapsedTimeNanos");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

