/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.palantir.gradle.junit.Report;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class Report_TestCase_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private String name;
    @Nullable
    private Report.Failure failure = null;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Report_TestCase_Builder() {
    }

    public static Report.TestCase.Builder from(Report.TestCase value) {
        return new Report.TestCase.Builder().mergeFrom(value);
    }

    public Report.TestCase.Builder name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (Report.TestCase.Builder)this;
    }

    public Report.TestCase.Builder mapName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.name((String)mapper.apply(this.name()));
    }

    public String name() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    public Report.TestCase.Builder failure(@Nullable Report.Failure failure) {
        this.failure = failure;
        return (Report.TestCase.Builder)this;
    }

    public Report.TestCase.Builder mapFailure(UnaryOperator<Report.Failure> mapper) {
        Preconditions.checkNotNull(mapper);
        Report.Failure failure = this.failure();
        if (failure != null) {
            this.failure((Report.Failure)mapper.apply(failure));
        }
        return (Report.TestCase.Builder)this;
    }

    @Nullable
    public Report.Failure failure() {
        return this.failure;
    }

    public Report.TestCase.Builder mergeFrom(Report.TestCase value) {
        Report.TestCase.Builder _defaults = new Report.TestCase.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.name(), ((Report_TestCase_Builder)_defaults).name())) {
            this.name(value.name());
        }
        if (!Objects.equals(value.failure(), ((Report_TestCase_Builder)_defaults).failure())) {
            this.failure(value.failure());
        }
        return (Report.TestCase.Builder)this;
    }

    public Report.TestCase.Builder mergeFrom(Report.TestCase.Builder template) {
        Report.TestCase.Builder base = template;
        Report.TestCase.Builder _defaults = new Report.TestCase.Builder();
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !_defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.name(), ((Report_TestCase_Builder)_defaults).name()))) {
            this.name(template.name());
        }
        if (!Objects.equals(template.failure(), ((Report_TestCase_Builder)_defaults).failure())) {
            this.failure(template.failure());
        }
        return (Report.TestCase.Builder)this;
    }

    public Report.TestCase.Builder clear() {
        Report.TestCase.Builder _defaults = new Report.TestCase.Builder();
        this.name = _defaults.name;
        this.failure = _defaults.failure;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (Report.TestCase.Builder)this;
    }

    public Report.TestCase build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public Report.TestCase buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements Report.TestCase {
        private final String name;
        @Nullable
        private final Report.Failure failure;
        private final EnumSet<Property> _unsetProperties;

        Partial(Report_TestCase_Builder builder) {
            this.name = builder.name;
            this.failure = builder.failure;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public String name() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        @Nullable
        public Report.Failure failure() {
            return this.failure;
        }

        @Override
        public Report.TestCase.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            if (!this._unsetProperties.contains((Object)Property.NAME)) {
                builder.name(this.name);
            }
            builder.failure(this.failure);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.failure, other.failure) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.failure, this._unsetProperties);
        }

        public String toString() {
            return "partial TestCase{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.NAME) ? "name=" + this.name : null), (Object)(this.failure != null ? "failure=" + this.failure : null), new Object[0]) + "}";
        }

        private static class PartialBuilder
        extends Report.TestCase.Builder {
            private PartialBuilder() {
            }

            @Override
            public Report.TestCase build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    implements Report.TestCase {
        private final String name;
        @Nullable
        private final Report.Failure failure;

        private Value(Report_TestCase_Builder builder) {
            this.name = builder.name;
            this.failure = builder.failure;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        @Nullable
        public Report.Failure failure() {
            return this.failure;
        }

        @Override
        public Report.TestCase.Builder toBuilder() {
            return new Report.TestCase.Builder().mergeFrom(this);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.failure, other.failure);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.failure);
        }

        public String toString() {
            return "TestCase{" + COMMA_JOINER.join((Object)("name=" + this.name), (Object)(this.failure != null ? "failure=" + this.failure : null), new Object[0]) + "}";
        }
    }

    private static enum Property {
        NAME("name");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

