/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.common.streams;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;

class BufferingSpliterator<T, F extends ListenableFuture<T>, U>
implements Spliterator<F> {
    private final int maxParallelism;
    private final BlockingQueue<F> completed;
    private final Spliterator<U> notStarted;
    private final Function<U, F> toFuture;
    private final CompletionStrategy completionStrategy;
    private int inProgress = 0;

    BufferingSpliterator(CompletionStrategy completionStrategy, Spliterator<U> input, Function<U, F> toFuture, int maxParallelism) {
        this.completionStrategy = completionStrategy;
        Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0, (String)"maxParallelism must be at least 1 (got %s)", (Object[])new Object[]{maxParallelism});
        this.maxParallelism = maxParallelism;
        this.completed = new ArrayBlockingQueue<F>(maxParallelism);
        this.notStarted = input;
        this.toFuture = toFuture;
    }

    @Override
    public boolean tryAdvance(Consumer<? super F> action) {
        this.startNewWorkIfNecessary();
        if (this.inProgress == 0) {
            return false;
        }
        try {
            ListenableFuture element = (ListenableFuture)this.completed.take();
            --this.inProgress;
            action.accept(element);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Spliterator<F> trySplit() {
        return null;
    }

    private void startNewWorkIfNecessary() {
        while (this.inProgress < this.maxParallelism) {
            boolean maybeRemainingElements = this.notStarted.tryAdvance((? super T nextInput) -> {
                ++this.inProgress;
                this.completionStrategy.registerCompletion((ListenableFuture)this.toFuture.apply(nextInput), this.completed::add);
            });
            if (maybeRemainingElements) continue;
            return;
        }
    }

    @Override
    public long estimateSize() {
        long estimate = (long)this.inProgress + this.notStarted.estimateSize();
        if (estimate < 0L) {
            return Long.MAX_VALUE;
        }
        return estimate;
    }

    @Override
    public int characteristics() {
        return 0x40 & this.notStarted.characteristics();
    }

    static enum InSourceOrder implements CompletionStrategy
    {
        INSTANCE;


        @Override
        public <T, F extends ListenableFuture<T>> void registerCompletion(F future, Consumer<F> resultConsumer) {
            resultConsumer.accept(future);
        }
    }

    static enum InCompletionOrder implements CompletionStrategy
    {
        INSTANCE;


        @Override
        public <T, F extends ListenableFuture<T>> void registerCompletion(F future, Consumer<F> resultConsumer) {
            future.addListener(() -> resultConsumer.accept(future), MoreExecutors.directExecutor());
        }
    }

    @FunctionalInterface
    static interface CompletionStrategy {
        public <T, F extends ListenableFuture<T>> void registerCompletion(F var1, Consumer<F> var2);
    }
}

