/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.common.streams;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.palantir.common.streams.KeyedStreamImpl;
import com.palantir.common.streams.MoreStreams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public interface KeyedStream<K, V> {
    default public KeyedStream<K, V> filter(Predicate<? super V> predicate) {
        return this.filterEntries((key, value) -> predicate.test((Object)value));
    }

    default public KeyedStream<K, V> filterKeys(Predicate<? super K> predicate) {
        return this.filterEntries((key, value) -> predicate.test((Object)key));
    }

    public KeyedStream<K, V> filterEntries(BiPredicate<? super K, ? super V> var1);

    default public <R> KeyedStream<K, R> map(Function<? super V, ? extends R> mapper) {
        return this.mapEntries((key, value) -> Maps.immutableEntry((Object)key, mapper.apply((Object)value)));
    }

    default public <R> KeyedStream<K, R> map(BiFunction<? super K, ? super V, ? extends R> entryMapper) {
        return this.mapEntries((key, value) -> Maps.immutableEntry((Object)key, entryMapper.apply((Object)key, (Object)value)));
    }

    default public <R> KeyedStream<R, V> mapKeys(Function<? super K, ? extends R> keyMapper) {
        return this.mapEntries((key, value) -> Maps.immutableEntry(keyMapper.apply((Object)key), (Object)value));
    }

    default public <R> KeyedStream<R, V> mapKeys(BiFunction<? super K, ? super V, ? extends R> keyMapper) {
        return this.mapEntries((key, value) -> Maps.immutableEntry(keyMapper.apply((Object)key, (Object)value), (Object)value));
    }

    public <K2, V2> KeyedStream<K2, V2> mapEntries(BiFunction<? super K, ? super V, ? extends Map.Entry<? extends K2, ? extends V2>> var1);

    default public <R> KeyedStream<K, R> flatMap(Function<? super V, ? extends Stream<? extends R>> mapper) {
        return this.flatMapEntries((key, value) -> ((Stream)mapper.apply((Object)value)).map((? super T newValue) -> Maps.immutableEntry((Object)key, (Object)newValue)));
    }

    default public <R> KeyedStream<K, R> flatMap(BiFunction<? super K, ? super V, ? extends Stream<? extends R>> entryMapper) {
        return this.flatMapEntries((key, value) -> ((Stream)entryMapper.apply((Object)key, (Object)value)).map((? super T newValue) -> Maps.immutableEntry((Object)key, (Object)newValue)));
    }

    default public <R> KeyedStream<R, V> flatMapKeys(Function<? super K, ? extends Stream<? extends R>> keyMapper) {
        return this.flatMapEntries((key, value) -> ((Stream)keyMapper.apply((Object)key)).map((? super T newKey) -> Maps.immutableEntry((Object)newKey, (Object)value)));
    }

    default public <R> KeyedStream<R, V> flatMapKeys(BiFunction<? super K, ? super V, ? extends Stream<? extends R>> keyMapper) {
        return this.flatMapEntries((key, value) -> ((Stream)keyMapper.apply((Object)key, (Object)value)).map((? super T newKey) -> Maps.immutableEntry((Object)newKey, (Object)value)));
    }

    public <K2, V2> KeyedStream<K2, V2> flatMapEntries(BiFunction<? super K, ? super V, ? extends Stream<? extends Map.Entry<? extends K2, ? extends V2>>> var1);

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        this.entries().forEach((? super T entry) -> action.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    default public Map<K, V> collectToMap() {
        return this.collectTo(LinkedHashMap::new);
    }

    default public SetMultimap<K, V> collectToSetMultimap() {
        return (SetMultimap)this.collectToMultimap(LinkedHashMultimap::create);
    }

    public <M extends Map<K, V>> M collectTo(Supplier<M> var1);

    public <M extends Multimap<K, V>> M collectToMultimap(Supplier<M> var1);

    default public Stream<K> keys() {
        return this.entries().map(Map.Entry::getKey);
    }

    default public Stream<V> values() {
        return this.entries().map(Map.Entry::getValue);
    }

    public Stream<Map.Entry<? extends K, ? extends V>> entries();

    public static <V> KeyedStream<V, V> of(Stream<V> stream) {
        return KeyedStream.ofEntries(stream.map((? super T value) -> Maps.immutableEntry((Object)value, (Object)value)));
    }

    public static <V> KeyedStream<V, V> of(Iterable<? extends V> items) {
        return KeyedStream.of(MoreStreams.stream(items));
    }

    public static <K, V> KeyedStream<K, V> stream(Map<K, V> map) {
        return KeyedStream.ofEntries(map.entrySet().stream());
    }

    public static <K, V> KeyedStream<K, V> stream(Multimap<K, V> multimap) {
        return KeyedStream.ofEntries(multimap.entries().stream());
    }

    public static <K, V> KeyedStream<K, V> ofEntries(Stream<Map.Entry<K, V>> entries) {
        return new KeyedStreamImpl(entries.map((? super T entry) -> entry));
    }

    @SafeVarargs
    public static <K, V> KeyedStream<K, V> join(KeyedStream<? extends K, ? extends V> ... keyedStreams) {
        return new KeyedStreamImpl(Arrays.stream(keyedStreams).flatMap(KeyedStream::entries));
    }

    public static <V> Collector<V, List<V>, KeyedStream<V, V>> toKeyedStream() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, values -> KeyedStream.of(values.stream()), new Collector.Characteristics[0]);
    }
}

