/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.common.streams;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.palantir.common.streams.KeyedStream;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

class KeyedStreamImpl<K, V>
implements KeyedStream<K, V> {
    private final Stream<Map.Entry<? extends K, ? extends V>> entries;

    KeyedStreamImpl(Stream<Map.Entry<? extends K, ? extends V>> entries) {
        this.entries = entries;
    }

    @Override
    public KeyedStream<K, V> filterEntries(BiPredicate<? super K, ? super V> predicate) {
        return new KeyedStreamImpl<K, V>(this.entries.filter((? super T entry) -> predicate.test((Object)entry.getKey(), (Object)entry.getValue())));
    }

    @Override
    public <T extends Map<K, V>> T collectTo(Supplier<T> supplier) {
        return (T)this.entries.collect(supplier, KeyedStreamImpl::accumulate, KeyedStreamImpl::combine);
    }

    @Override
    public <M extends Multimap<K, V>> M collectToMultimap(Supplier<M> supplier) {
        return (M)this.entries.collect(supplier, KeyedStreamImpl::accumulate, KeyedStreamImpl::combine);
    }

    @Override
    public <K2, V2> KeyedStream<K2, V2> mapEntries(BiFunction<? super K, ? super V, ? extends Map.Entry<? extends K2, ? extends V2>> entryMapper) {
        return new KeyedStreamImpl<K, V>(this.entries.map((? super T entry) -> (Map.Entry)entryMapper.apply((Object)entry.getKey(), (Object)entry.getValue())));
    }

    @Override
    public <K2, V2> KeyedStream<K2, V2> flatMapEntries(BiFunction<? super K, ? super V, ? extends Stream<? extends Map.Entry<? extends K2, ? extends V2>>> entryMapper) {
        return new KeyedStreamImpl<K, V>(this.entries.flatMap((? super T entry) -> (Stream)entryMapper.apply((Object)entry.getKey(), (Object)entry.getValue())));
    }

    @Override
    public Stream<Map.Entry<? extends K, ? extends V>> entries() {
        return this.entries;
    }

    private static <K, V> void accumulate(Map<K, V> map, Map.Entry<? extends K, ? extends V> entry) {
        Preconditions.checkState((!map.containsKey(entry.getKey()) ? 1 : 0) != 0, (String)"Duplicate key %s", (Object[])new Object[]{entry.getKey()});
        map.put(entry.getKey(), entry.getValue());
    }

    private static <K, V> void accumulate(Multimap<K, V> multimap, Map.Entry<? extends K, ? extends V> entry) {
        multimap.put(entry.getKey(), entry.getValue());
    }

    private static <K, V> void combine(Map<K, V> map, Map<K, V> entries) {
        Sets.SetView duplicates = Sets.intersection(map.keySet(), entries.keySet());
        if (!duplicates.isEmpty()) {
            throw new IllegalStateException("Duplicate keys " + (Set)duplicates);
        }
        map.putAll(entries);
    }

    private static <K, V> void combine(Multimap<K, V> multimap, Multimap<K, V> entries) {
        multimap.putAll(entries);
    }
}

